import pg from "./tool/pg_hy02_paopao";

const { ccclass, property } = cc._decorator;
@ccclass
export default class Clund_06 extends cc.Component {
    private gameWidth;
    private gameHeight;
    public onEnable() {

    }
    protected onDestroy(): void {
    }
    protected onLoad(): void {
        const gameCanvas = cc.view.getVisibleSize();
        this.gameWidth = gameCanvas.width / 2;
        this.gameHeight = gameCanvas.height / 2;
        pg.event.on("bullet_shoot", (angle) => {
            if (angle > 80) angle = 80;
            if (angle < -80) angle = -80;
            this.jAngle = angle;
            this.node.angle = angle;
            this.runShoot = true;
        });
        pg.event.on("stop_shoot", () => {
            this.node.x = 0;
            // this.node.y = -542;
            this.node.angle = 0;
            this.runShoot = false;
        })

    }
    private jAngle;
    private runShoot;
    protected update(dt) {
        if (!this.runShoot) return;
        //子弹位移
        let speed = 50;
        let nextPos = this.angleAndDistance2Point(this.jAngle, speed);
        this.node.x += nextPos.x;
        this.node.y += nextPos.y;

        if (this.node.x < -this.gameWidth || this.node.x > this.gameWidth || this.node.y > this.gameHeight) {
            this.node.x = 0;
            this.node.y = -542;
            this.node.angle = 0;
            this.runShoot = false;
            pg.event.emit("bullet_reset_pos");
        }
    }
    private angleAndDistance2Point(A: number, c: number) {
        //sinA = a/c   cosA = b/c   tanA = a/b  cotA=b/a
        let ARadians = cc.misc.degreesToRadians(A + 90);
        let a = Math.sin(ARadians) * c;//  a/c * c;
        let b = Math.cos(ARadians) * c;//  b/c * c;
        return cc.v2(b, a);
    }

}
