/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnChanges, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { CandyDate, FunctionProp } from 'ng-zorro-antd/core';
import { NzCalendarI18nInterface } from 'ng-zorro-antd/i18n';
import { CompatibleValue, DisabledDateFn, DisabledTimeConfig, DisabledTimeFn, PanelMode, PresetRanges, SupportTimeOptions } from '../../standard-types';
import * as ɵngcc0 from '@angular/core';
export declare class DateRangePopupComponent implements OnInit, OnChanges {
    isRange: boolean;
    showWeek: boolean;
    locale: NzCalendarI18nInterface;
    format: string;
    placeholder: string | string[];
    disabledDate: DisabledDateFn;
    disabledTime: DisabledTimeFn;
    showToday: boolean;
    showTime: SupportTimeOptions | boolean;
    extraFooter: TemplateRef<void> | string;
    ranges: PresetRanges;
    dateRender: FunctionProp<TemplateRef<Date> | string>;
    popupStyle: object;
    dropdownClassName: string;
    panelMode: PanelMode | PanelMode[];
    value: CompatibleValue;
    readonly panelModeChange: EventEmitter<"decade" | "year" | "month" | "date" | "time" | PanelMode[]>;
    readonly calendarChange: EventEmitter<CompatibleValue>;
    readonly valueChange: EventEmitter<CompatibleValue>;
    readonly inputChange: EventEmitter<CompatibleValue>;
    readonly resultOk: EventEmitter<void>;
    readonly closePicker: EventEmitter<void>;
    prefixCls: string;
    showTimePicker: boolean;
    timeOptions: SupportTimeOptions | SupportTimeOptions[] | null;
    valueForRangeShow: CandyDate[];
    selectedValue: CandyDate[];
    hoverValue: CandyDate[];
    readonly hasTimePicker: boolean;
    readonly hasFooter: boolean;
    private partTypeMap;
    [property: string]: any;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    onShowTimePickerChange(show: boolean): void;
    onClickOk(): void;
    onClickToday(value: CandyDate): void;
    onDayHover(value: CandyDate): void;
    onPanelModeChange(mode: PanelMode, partType?: RangePartType): void;
    onHeaderChange(value: CandyDate, partType?: RangePartType): void;
    onSelectTime(value: CandyDate, partType?: RangePartType): void;
    changeValueFromInput(value: {
        date: CandyDate;
        isEnter: boolean;
    }, partType?: RangePartType): void;
    changeValueFromSelect(value: CandyDate): void;
    enablePrevNext(direction: 'prev' | 'next', partType?: RangePartType): boolean;
    getPanelMode(partType?: RangePartType): PanelMode;
    getValue(partType?: RangePartType): CandyDate;
    getValueBySelector(partType?: RangePartType): CandyDate;
    getPartTypeIndex(partType?: RangePartType): number;
    getPlaceholder(partType?: RangePartType): string;
    hasSelectedValue(): boolean;
    disabledStartTime: (value: Date | Date[]) => DisabledTimeConfig;
    disabledEndTime: (value: Date | Date[]) => DisabledTimeConfig;
    isAllowedSelectedValue(): boolean;
    timePickerDisabled(): boolean;
    okDisabled(): boolean;
    getTimeOptions(partType?: RangePartType): SupportTimeOptions | null;
    onClickPresetRange(val: PresetRanges[keyof PresetRanges]): void;
    onPresetRangeMouseLeave(): void;
    onHoverPresetRange(val: PresetRanges[keyof PresetRanges]): void;
    getObjectKeys(obj: object): string[];
    private closePickerPanel;
    private clearHoverValue;
    private buildTimeOptions;
    private overrideTimeOptions;
    private setValueFromInput;
    private setValue;
    private overrideHms;
    private isValidRange;
    private normalizeRangeValue;
    private setRangeValue;
    private cloneRangeDate;
    private initialArray;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<DateRangePopupComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<DateRangePopupComponent, "date-range-popup", ["dateRangePopup"], {
    "value": "value";
    "panelMode": "panelMode";
    "isRange": "isRange";
    "showWeek": "showWeek";
    "locale": "locale";
    "format": "format";
    "placeholder": "placeholder";
    "disabledDate": "disabledDate";
    "disabledTime": "disabledTime";
    "showToday": "showToday";
    "showTime": "showTime";
    "extraFooter": "extraFooter";
    "ranges": "ranges";
    "dateRender": "dateRender";
    "popupStyle": "popupStyle";
    "dropdownClassName": "dropdownClassName";
}, {
    "panelModeChange": "panelModeChange";
    "calendarChange": "calendarChange";
    "valueChange": "valueChange";
    "inputChange": "inputChange";
    "resultOk": "resultOk";
    "closePicker": "closePicker";
}, never>;
}
export declare type RangePartType = 'left' | 'right';

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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