/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Overlay } from '@angular/cdk/overlay';
import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef, ViewContainerRef } from '@angular/core';
import { NzMentionTriggerDirective } from './nz-mention-trigger';
import { NzMentionService } from './nz-mention.service';
import * as ɵngcc0 from '@angular/core';
export interface MentionOnSearchTypes {
    value: string;
    prefix: string;
}
export interface Mention {
    startPos: number;
    endPos: number;
    mention: string;
}
export declare type MentionPlacement = 'top' | 'bottom';
export declare class NzMentionComponent implements OnDestroy, OnInit, OnChanges {
    private ngDocument;
    private changeDetectorRef;
    private overlay;
    private viewContainerRef;
    private nzMentionService;
    nzValueWith: (value: any) => string;
    nzPrefix: string | string[];
    nzLoading: boolean;
    nzNotFoundContent: string;
    nzPlacement: MentionPlacement;
    nzSuggestions: string[];
    readonly nzOnSelect: EventEmitter<string | {}>;
    readonly nzOnSearchChange: EventEmitter<MentionOnSearchTypes>;
    trigger: NzMentionTriggerDirective;
    suggestionsTemp: TemplateRef<void>;
    suggestionChild: TemplateRef<{
        $implicit: any;
    }>;
    isOpen: boolean;
    filteredSuggestions: string[];
    suggestionTemplate: TemplateRef<{
        $implicit: any;
    }> | null;
    activeIndex: number;
    private previousValue;
    private cursorMention;
    private cursorMentionStart;
    private cursorMentionEnd;
    private overlayRef;
    private portal;
    private positionStrategy;
    private overlayBackdropClickSubscription;
    private readonly triggerNativeElement;
    constructor(ngDocument: any, // tslint:disable-line:no-any
    changeDetectorRef: ChangeDetectorRef, overlay: Overlay, viewContainerRef: ViewContainerRef, nzMentionService: NzMentionService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    closeDropdown(): void;
    openDropdown(): void;
    getMentions(): string[];
    selectSuggestion(suggestion: string | {}): void;
    private handleInput;
    private handleKeydown;
    private handleClick;
    private bindTriggerEvents;
    private suggestionsFilter;
    private resetDropdown;
    private setNextItemActive;
    private setPreviousItemActive;
    private canOpen;
    private resetCursorMention;
    private updatePositions;
    private subscribeOverlayBackdropClick;
    private attachOverlay;
    private getOverlayConfig;
    private getOverlayPosition;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzMentionComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzMentionComponent, "nz-mention", ["nzMention"], {
    "nzValueWith": "nzValueWith";
    "nzPrefix": "nzPrefix";
    "nzLoading": "nzLoading";
    "nzNotFoundContent": "nzNotFoundContent";
    "nzPlacement": "nzPlacement";
    "nzSuggestions": "nzSuggestions";
}, {
    "nzOnSelect": "nzOnSelect";
    "nzOnSearchChange": "nzOnSearchChange";
}, ["suggestionChild"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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