// pg.event.once('layer_ending_touch_replay', () => {
//     alert('replay')
// })
// pg.event.emit('layer_ending_show')
import pg from "../../scene/tool/pg_hy02_paopao";

const { ccclass, property } = cc._decorator;

@ccclass
export default class LayerEnding extends cc.Component {
    private layer_center: cc.Node;
    private replay_btn: cc.Node;
    private next_btn: cc.Node;
    private res: cc.Node;
    onLoad() {
        this.layer_center = pg.view.find(this.node, "layer_center")
        this.res = pg.view.find(this.node, "res")
        pg.view.visible(this.layer_center, false);
        this.replay_btn = pg.view.find(this.layer_center, "replay_btn")
        this.next_btn = pg.view.find(this.layer_center, "next_btn")
        pg.view.touchOn(this.replay_btn, this.onTouchReplay, this)
        pg.view.touchOn(this.next_btn, this.onTouchNext, this)
        pg.event.on('layer_ending_show', (data) => {
            // this.showLayer(data);
            this.onTouchNext();
        })
    }
    showLayer(data) {
        let ending = pg.view.find(this.res, "ending")
        pg.audio.playLocalAudio(ending)
        pg.view.visible(this.layer_center, true)
        pg.view.setString(pg.view.find(this.layer_center, 'finish_box/coin_num'), 'X' + data.coin);
        let finish_cat = pg.view.find(this.layer_center, "finish_cat")
        pg.view.playDBAnimation(finish_cat, "finish", 1);
        let bg_light = pg.view.find(this.layer_center, "bg_light")
        cc.tween(bg_light).by(2, { angle: 360 }).repeatForever().start();
        pg.view.visible(this.layer_center, true)
    }

    onTouchReplay() {
        pg.view.visible(this.layer_center, false)
        pg.event.emit('layer_ending_touch_replay');
    }

    onTouchNext() {
        pg.view.visible(this.layer_center, false)
        const middleLayer = cc.find('middleLayer');
        if (!middleLayer) return this.log("no middleLayer ");
        const middleLayerComponent = middleLayer.getComponent('middleLayer');
        const { index, length } = middleLayerComponent.getPageInfo(); // 返回 length:有多少页; index: 当前第几页（从0开始）
        this.log("跳转到下一页 ");
        if (index == length - 1) {
            middleLayerComponent.goNextCross(); // 跳转到下一关卡
        } else {
            middleLayerComponent.goNextPage();  // 跳转到下一页
        }
    }
    log(str) {
        const node = cc.find('middleLayer');
        if (node) {
            node.getComponent('middleLayer').log(str);
        } else {
            cc.log(str);
        }
    }
}


