/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ScrollDispatcher, ViewportRuler } from '@angular/cdk/scrolling';
import { NgZone } from '@angular/core';
import { BlockScrollStrategy } from './block-scroll-strategy';
import { CloseScrollStrategy, CloseScrollStrategyConfig } from './close-scroll-strategy';
import { NoopScrollStrategy } from './noop-scroll-strategy';
import { RepositionScrollStrategy, RepositionScrollStrategyConfig } from './reposition-scroll-strategy';
/**
 * Options for how an overlay will handle scrolling.
 *
 * Users can provide a custom value for `ScrollStrategyOptions` to replace the default
 * behaviors. This class primarily acts as a factory for ScrollStrategy instances.
 */
import * as ɵngcc0 from '@angular/core';
export declare class ScrollStrategyOptions {
    private _scrollDispatcher;
    private _viewportRuler;
    private _ngZone;
    private _document;
    constructor(_scrollDispatcher: ScrollDispatcher, _viewportRuler: ViewportRuler, _ngZone: NgZone, document: any);
    /** Do nothing on scroll. */
    noop: () => NoopScrollStrategy;
    /**
     * Close the overlay as soon as the user scrolls.
     * @param config Configuration to be used inside the scroll strategy.
     */
    close: (config?: CloseScrollStrategyConfig | undefined) => CloseScrollStrategy;
    /** Block scrolling. */
    block: () => BlockScrollStrategy;
    /**
     * Update the overlay's position on scroll.
     * @param config Configuration to be used inside the scroll strategy.
     * Allows debouncing the reposition calls.
     */
    reposition: (config?: RepositionScrollStrategyConfig | undefined) => RepositionScrollStrategy;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<ScrollStrategyOptions>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<ScrollStrategyOptions>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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