/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { TransferItem } from './interface';
import * as ɵngcc0 from '@angular/core';
export declare class NzTransferListComponent implements OnChanges, OnInit {
    private el;
    private updateHostClassService;
    private cdr;
    direction: string;
    titleText: string;
    showSelectAll: boolean;
    dataSource: TransferItem[];
    itemUnit: string;
    itemsUnit: string;
    filter: string;
    disabled: boolean;
    showSearch: boolean;
    searchPlaceholder: string;
    notFoundContent: string;
    filterOption: (inputValue: string, item: TransferItem) => boolean;
    renderList: TemplateRef<void>;
    render: TemplateRef<void>;
    footer: TemplateRef<void>;
    readonly handleSelectAll: EventEmitter<boolean>;
    readonly handleSelect: EventEmitter<TransferItem>;
    readonly filterChange: EventEmitter<{
        direction: string;
        value: string;
    }>;
    prefixCls: string;
    setClassMap(): void;
    stat: {
        checkAll: boolean;
        checkHalf: boolean;
        checkCount: number;
        shownCount: number;
    };
    onItemSelect: (item: TransferItem) => void;
    onItemSelectAll: (status: boolean) => void;
    private updateCheckStatus;
    handleFilter(value: string): void;
    handleClear(): void;
    private matchFilter;
    constructor(el: ElementRef, updateHostClassService: NzUpdateHostClassService, cdr: ChangeDetectorRef);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    markForCheck(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTransferListComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTransferListComponent, "nz-transfer-list", ["nzTransferList"], {
    "direction": "direction";
    "titleText": "titleText";
    "showSelectAll": "showSelectAll";
    "dataSource": "dataSource";
    "itemUnit": "itemUnit";
    "itemsUnit": "itemsUnit";
    "filter": "filter";
    "disabled": "disabled";
    "showSearch": "showSearch";
    "searchPlaceholder": "searchPlaceholder";
    "notFoundContent": "notFoundContent";
    "filterOption": "filterOption";
    "renderList": "renderList";
    "render": "render";
    "footer": "footer";
}, {
    "handleSelectAll": "handleSelectAll";
    "handleSelect": "handleSelect";
    "filterChange": "filterChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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