/// <amd-module name="@angular/compiler-cli/ngcc/src/analysis/module_with_providers_analyzer" />
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as ts from 'typescript';
import { ReferencesRegistry } from '../../../src/ngtsc/annotations';
import { ClassDeclaration, ConcreteDeclaration } from '../../../src/ngtsc/reflection';
import { NgccReflectionHost } from '../host/ngcc_host';
export interface ModuleWithProvidersInfo {
    /**
     * The declaration (in the .d.ts file) of the function that returns
     * a `ModuleWithProviders object, but has a signature that needs
     * a type parameter adding.
     */
    declaration: ts.MethodDeclaration | ts.FunctionDeclaration;
    /**
     * The NgModule class declaration (in the .d.ts file) to add as a type parameter.
     */
    ngModule: ConcreteDeclaration<ClassDeclaration>;
}
export declare type ModuleWithProvidersAnalyses = Map<ts.SourceFile, ModuleWithProvidersInfo[]>;
export declare const ModuleWithProvidersAnalyses: MapConstructor;
export declare class ModuleWithProvidersAnalyzer {
    private host;
    private referencesRegistry;
    private processDts;
    constructor(host: NgccReflectionHost, referencesRegistry: ReferencesRegistry, processDts: boolean);
    analyzeProgram(program: ts.Program): ModuleWithProvidersAnalyses;
    private getRootFiles;
    private getDtsDeclarationForFunction;
    private resolveNgModuleReference;
}
