/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { makeDecorator } from '../util/decorators';
import { getInjectableDef, ɵɵdefineInjectable } from './interface/defs';
import { compileInjectable as render3CompileInjectable } from './jit/injectable';
import { convertInjectableProviderToFactory } from './util';
var ɵ0 = function (type, meta) { return SWITCH_COMPILE_INJECTABLE(type, meta); };
/**
 * Injectable decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Injectable = makeDecorator('Injectable', undefined, undefined, undefined, ɵ0);
/**
 * Supports @Injectable() in JIT mode for Render2.
 */
function render2CompileInjectable(injectableType, options) {
    if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
        injectableType.ɵprov = ɵɵdefineInjectable({
            token: injectableType,
            providedIn: options.providedIn,
            factory: convertInjectableProviderToFactory(injectableType, options),
        });
    }
}
export var SWITCH_COMPILE_INJECTABLE__POST_R3__ = render3CompileInjectable;
var SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
var SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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