/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import * as tslib_1 from "tslib";
import { DOCUMENT } from '@angular/common';
import { HttpBackend, HttpClient } from '@angular/common/http';
import { Inject, Optional, RendererFactory2, SecurityContext } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { of as rxof, Observable, Subject } from 'rxjs';
import { catchError, filter, finalize, map, share, take, tap } from 'rxjs/operators';
import { cloneSVG, getIconDefinitionFromAbbr, getNameAndNamespace, getSecondaryColor, hasNamespace, isIconDefinition, replaceFillColor, warn, withSuffix, withSuffixAndColor } from '../utils';
import { DynamicLoadingTimeoutError, HttpModuleNotImport, IconNotFoundError, NameSpaceIsNotSpecifyError, SVGTagNotFoundError, UrlNotSafeError } from './icon.error';
/** @type {?} */
var JSONP_HANDLER_NAME = '__ant_icon_load';
var IconService = /** @class */ (function () {
    function IconService(_rendererFactory, _handler, _document, sanitizer) {
        this._rendererFactory = _rendererFactory;
        this._handler = _handler;
        this._document = _document;
        this.sanitizer = sanitizer;
        this.defaultTheme = 'outline';
        /**
         * All icon definitions would be registered here.
         */
        this._svgDefinitions = new Map();
        /**
         * Cache all rendered icons. Icons are identified by name, theme,
         * and for twotone icons, primary color and secondary color.
         */
        this._svgRenderedDefinitions = new Map();
        this._inProgressFetches = new Map();
        /**
         * Url prefix for fetching inline SVG by dynamic importing.
         */
        this._assetsUrlRoot = '';
        this._twoToneColorPalette = {
            primaryColor: '#333333',
            secondaryColor: '#E6E6E6'
        };
        /**
         * A flag indicates whether jsonp loading is enabled.
         */
        this._enableJsonpLoading = false;
        this._jsonpIconLoad$ = new Subject();
        this._renderer = this._rendererFactory.createRenderer(null, null);
        if (this._handler) {
            this._http = new HttpClient(this._handler);
        }
    }
    Object.defineProperty(IconService.prototype, "twoToneColor", {
        get: /**
         * @return {?}
         */
        function () {
            // Make a copy to avoid unexpected changes.
            return (/** @type {?} */ (tslib_1.__assign({}, this._twoToneColorPalette)));
        },
        set: /**
         * @param {?} __0
         * @return {?}
         */
        function (_a) {
            var primaryColor = _a.primaryColor, secondaryColor = _a.secondaryColor;
            this._twoToneColorPalette.primaryColor = primaryColor;
            this._twoToneColorPalette.secondaryColor =
                secondaryColor || getSecondaryColor(primaryColor);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Call this method to switch to jsonp like loading.
     */
    /**
     * Call this method to switch to jsonp like loading.
     * @return {?}
     */
    IconService.prototype.useJsonpLoading = /**
     * Call this method to switch to jsonp like loading.
     * @return {?}
     */
    function () {
        var _this = this;
        if (!this._enableJsonpLoading) {
            this._enableJsonpLoading = true;
            window[JSONP_HANDLER_NAME] = (/**
             * @param {?} icon
             * @return {?}
             */
            function (icon) {
                _this._jsonpIconLoad$.next(icon);
            });
        }
        else {
            warn('You are already using jsonp loading.');
        }
    };
    /**
     * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
     * @param prefix
     */
    /**
     * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
     * @param {?} prefix
     * @return {?}
     */
    IconService.prototype.changeAssetsSource = /**
     * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
     * @param {?} prefix
     * @return {?}
     */
    function (prefix) {
        this._assetsUrlRoot = prefix.endsWith('/') ? prefix : prefix + '/';
    };
    /**
     * Add icons provided by ant design.
     * @param icons
     */
    /**
     * Add icons provided by ant design.
     * @param {...?} icons
     * @return {?}
     */
    IconService.prototype.addIcon = /**
     * Add icons provided by ant design.
     * @param {...?} icons
     * @return {?}
     */
    function () {
        var _this = this;
        var icons = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            icons[_i] = arguments[_i];
        }
        icons.forEach((/**
         * @param {?} icon
         * @return {?}
         */
        function (icon) {
            _this._svgDefinitions.set(withSuffix(icon.name, icon.theme), icon);
        }));
    };
    /**
     * Register an icon. Namespace is required.
     * @param type
     * @param literal
     */
    /**
     * Register an icon. Namespace is required.
     * @param {?} type
     * @param {?} literal
     * @return {?}
     */
    IconService.prototype.addIconLiteral = /**
     * Register an icon. Namespace is required.
     * @param {?} type
     * @param {?} literal
     * @return {?}
     */
    function (type, literal) {
        var _a = tslib_1.__read(getNameAndNamespace(type), 2), _ = _a[0], namespace = _a[1];
        if (!namespace) {
            throw NameSpaceIsNotSpecifyError();
        }
        this.addIcon({ name: type, icon: literal });
    };
    /**
     * Remove all cache.
     */
    /**
     * Remove all cache.
     * @return {?}
     */
    IconService.prototype.clear = /**
     * Remove all cache.
     * @return {?}
     */
    function () {
        this._svgDefinitions.clear();
        this._svgRenderedDefinitions.clear();
    };
    /**
     * Get a rendered `SVGElement`.
     * @param icon
     * @param twoToneColor
     */
    /**
     * Get a rendered `SVGElement`.
     * @param {?} icon
     * @param {?=} twoToneColor
     * @return {?}
     */
    IconService.prototype.getRenderedContent = /**
     * Get a rendered `SVGElement`.
     * @param {?} icon
     * @param {?=} twoToneColor
     * @return {?}
     */
    function (icon, twoToneColor) {
        var _this = this;
        // If `icon` is a `IconDefinition`, go to the next step. If not, try to fetch it from cache.
        /** @type {?} */
        var definitionOrNull = isIconDefinition(icon)
            ? ((/** @type {?} */ (icon)))
            : this._svgDefinitions.get(icon) || null;
        // If `icon` is a `IconDefinition` of successfully fetch, wrap it in an `Observable`.
        // Otherwise try to fetch it from remote.
        /** @type {?} */
        var $iconDefinition = definitionOrNull
            ? rxof(definitionOrNull)
            : this._loadIconDynamically((/** @type {?} */ (icon)));
        // If finally get an `IconDefinition`, render and return it. Otherwise throw an error.
        return $iconDefinition.pipe(map((/**
         * @param {?} i
         * @return {?}
         */
        function (i) {
            if (!i) {
                throw IconNotFoundError((/** @type {?} */ (icon)));
            }
            return _this._loadSVGFromCacheOrCreateNew(i, twoToneColor);
        })));
    };
    /**
     * @return {?}
     */
    IconService.prototype.getCachedIcons = /**
     * @return {?}
     */
    function () {
        return this._svgDefinitions;
    };
    /**
     * Get raw svg and assemble a `IconDefinition` object.
     * @param type
     */
    /**
     * Get raw svg and assemble a `IconDefinition` object.
     * @protected
     * @param {?} type
     * @return {?}
     */
    IconService.prototype._loadIconDynamically = /**
     * Get raw svg and assemble a `IconDefinition` object.
     * @protected
     * @param {?} type
     * @return {?}
     */
    function (type) {
        var _this = this;
        // If developer doesn't provide HTTP module nor enable jsonp loading, just throw an error.
        if (!this._http && !this._enableJsonpLoading) {
            return rxof(HttpModuleNotImport());
        }
        // If multi directive ask for the same icon at the same time,
        // request should only be fired once.
        /** @type {?} */
        var inProgress = this._inProgressFetches.get(type);
        if (!inProgress) {
            var _a = tslib_1.__read(getNameAndNamespace(type), 2), name_1 = _a[0], namespace = _a[1];
            // If the string has a namespace within, create a simple `IconDefinition`.
            /** @type {?} */
            var icon_1 = namespace
                ? { name: type, icon: '' }
                : getIconDefinitionFromAbbr(name_1);
            /** @type {?} */
            var suffix = this._enableJsonpLoading ? '.js' : '.svg';
            /** @type {?} */
            var url = (namespace
                ? this._assetsUrlRoot + "assets/" + namespace + "/" + name_1
                : this._assetsUrlRoot + "assets/" + icon_1.theme + "/" + icon_1.name) + suffix;
            /** @type {?} */
            var safeUrl = this.sanitizer.sanitize(SecurityContext.URL, url);
            if (!safeUrl) {
                throw UrlNotSafeError(url);
            }
            /** @type {?} */
            var source = !this._enableJsonpLoading
                ? this._http
                    .get(safeUrl, { responseType: 'text' })
                    .pipe(map((/**
                 * @param {?} literal
                 * @return {?}
                 */
                function (literal) { return (tslib_1.__assign({}, icon_1, { icon: literal })); })))
                : this._loadIconDynamicallyWithJsonp(icon_1, safeUrl);
            inProgress = source.pipe(tap((/**
             * @param {?} definition
             * @return {?}
             */
            function (definition) { return _this.addIcon(definition); })), finalize((/**
             * @return {?}
             */
            function () { return _this._inProgressFetches.delete(type); })), catchError((/**
             * @return {?}
             */
            function () { return rxof(null); })), share());
            this._inProgressFetches.set(type, inProgress);
        }
        return inProgress;
    };
    /**
     * @protected
     * @param {?} icon
     * @param {?} url
     * @return {?}
     */
    IconService.prototype._loadIconDynamicallyWithJsonp = /**
     * @protected
     * @param {?} icon
     * @param {?} url
     * @return {?}
     */
    function (icon, url) {
        var _this = this;
        return new Observable((/**
         * @param {?} subscriber
         * @return {?}
         */
        function (subscriber) {
            /** @type {?} */
            var loader = _this._document.createElement('script');
            /** @type {?} */
            var timer = setTimeout((/**
             * @return {?}
             */
            function () {
                clean();
                subscriber.error(DynamicLoadingTimeoutError());
            }), 6000);
            loader.src = url;
            /**
             * @return {?}
             */
            function clean() {
                loader.parentNode.removeChild(loader);
                clearTimeout(timer);
            }
            _this._document.body.appendChild(loader);
            _this._jsonpIconLoad$
                .pipe(filter((/**
             * @param {?} i
             * @return {?}
             */
            function (i) { return i.name === icon.name && i.theme === icon.theme; })), take(1))
                .subscribe((/**
             * @param {?} i
             * @return {?}
             */
            function (i) {
                subscriber.next(i);
                clean();
            }));
        }));
    };
    /**
     * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
     * @param icon
     * @param twoToneColor
     */
    /**
     * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
     * @protected
     * @param {?} icon
     * @param {?=} twoToneColor
     * @return {?}
     */
    IconService.prototype._loadSVGFromCacheOrCreateNew = /**
     * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
     * @protected
     * @param {?} icon
     * @param {?=} twoToneColor
     * @return {?}
     */
    function (icon, twoToneColor) {
        /** @type {?} */
        var svg;
        /** @type {?} */
        var pri = twoToneColor || this._twoToneColorPalette.primaryColor;
        /** @type {?} */
        var sec = getSecondaryColor(pri) || this._twoToneColorPalette.secondaryColor;
        /** @type {?} */
        var key = icon.theme === 'twotone'
            ? withSuffixAndColor(icon.name, icon.theme, pri, sec)
            : icon.theme === undefined
                ? icon.name
                : withSuffix(icon.name, icon.theme);
        // Try to make a copy from cache.
        /** @type {?} */
        var cached = this._svgRenderedDefinitions.get(key);
        if (cached) {
            svg = cached.icon;
        }
        else {
            svg = this._setSVGAttribute(this._colorizeSVGIcon(
            // Icons provided by ant design should be refined to remove preset colors.
            this._createSVGElementFromString(hasNamespace(icon.name) ? icon.icon : replaceFillColor(icon.icon)), icon.theme === 'twotone', pri, sec));
            // Cache it.
            this._svgRenderedDefinitions.set(key, (/** @type {?} */ (tslib_1.__assign({}, icon, { icon: svg }))));
        }
        return cloneSVG(svg);
    };
    /**
     * @protected
     * @param {?} str
     * @return {?}
     */
    IconService.prototype._createSVGElementFromString = /**
     * @protected
     * @param {?} str
     * @return {?}
     */
    function (str) {
        /** @type {?} */
        var div = this._document.createElement('div');
        div.innerHTML = str;
        /** @type {?} */
        var svg = div.querySelector('svg');
        if (!svg) {
            throw SVGTagNotFoundError;
        }
        return svg;
    };
    /**
     * @protected
     * @param {?} svg
     * @return {?}
     */
    IconService.prototype._setSVGAttribute = /**
     * @protected
     * @param {?} svg
     * @return {?}
     */
    function (svg) {
        this._renderer.setAttribute(svg, 'width', '1em');
        this._renderer.setAttribute(svg, 'height', '1em');
        return svg;
    };
    /**
     * @protected
     * @param {?} svg
     * @param {?} twotone
     * @param {?} pri
     * @param {?} sec
     * @return {?}
     */
    IconService.prototype._colorizeSVGIcon = /**
     * @protected
     * @param {?} svg
     * @param {?} twotone
     * @param {?} pri
     * @param {?} sec
     * @return {?}
     */
    function (svg, twotone, pri, sec) {
        if (twotone) {
            /** @type {?} */
            var children = svg.childNodes;
            /** @type {?} */
            var length_1 = children.length;
            for (var i = 0; i < length_1; i++) {
                /** @type {?} */
                var child = (/** @type {?} */ (children[i]));
                if (child.getAttribute('fill') === 'secondaryColor') {
                    this._renderer.setAttribute(child, 'fill', sec);
                }
                else {
                    this._renderer.setAttribute(child, 'fill', pri);
                }
            }
        }
        this._renderer.setAttribute(svg, 'fill', 'currentColor');
        return svg;
    };
    /** @nocollapse */
    IconService.ctorParameters = function () { return [
        { type: RendererFactory2 },
        { type: HttpBackend, decorators: [{ type: Optional }] },
        { type: undefined, decorators: [{ type: Optional }, { type: Inject, args: [DOCUMENT,] }] },
        { type: DomSanitizer }
    ]; };
    return IconService;
}());
export { IconService };
if (false) {
    /** @type {?} */
    IconService.prototype.defaultTheme;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._renderer;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._http;
    /**
     * All icon definitions would be registered here.
     * @type {?}
     * @protected
     */
    IconService.prototype._svgDefinitions;
    /**
     * Cache all rendered icons. Icons are identified by name, theme,
     * and for twotone icons, primary color and secondary color.
     * @type {?}
     * @protected
     */
    IconService.prototype._svgRenderedDefinitions;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._inProgressFetches;
    /**
     * Url prefix for fetching inline SVG by dynamic importing.
     * @type {?}
     * @protected
     */
    IconService.prototype._assetsUrlRoot;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._twoToneColorPalette;
    /**
     * A flag indicates whether jsonp loading is enabled.
     * @type {?}
     * @private
     */
    IconService.prototype._enableJsonpLoading;
    /**
     * @type {?}
     * @private
     */
    IconService.prototype._jsonpIconLoad$;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._rendererFactory;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._handler;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype._document;
    /**
     * @type {?}
     * @protected
     */
    IconService.prototype.sanitizer;
}
//# sourceMappingURL=data:application/json;base64,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