/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { OnDestroy } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { NzTreeNode } from './nz-tree-base-node';
import { NzFormatEmitEvent } from './nz-tree-base.definitions';
import * as ɵngcc0 from '@angular/core';
export declare class NzTreeBaseService implements OnDestroy {
    DRAG_SIDE_RANGE: number;
    DRAG_MIN_GAP: number;
    isCheckStrictly: boolean;
    isMultiple: boolean;
    selectedNode: NzTreeNode;
    rootNodes: NzTreeNode[];
    selectedNodeList: NzTreeNode[];
    expandedNodeList: NzTreeNode[];
    checkedNodeList: NzTreeNode[];
    halfCheckedNodeList: NzTreeNode[];
    matchedNodeList: NzTreeNode[];
    triggerEventChange$: Subject<NzFormatEmitEvent>;
    /**
     * trigger event
     */
    eventTriggerChanged(): Observable<NzFormatEmitEvent>;
    /**
     * reset tree nodes will clear default node list
     */
    initTree(nzNodes: NzTreeNode[]): void;
    getSelectedNode(): NzTreeNode | null;
    /**
     * get some list
     */
    getSelectedNodeList(): NzTreeNode[];
    /**
     * return checked nodes
     */
    getCheckedNodeList(): NzTreeNode[];
    getHalfCheckedNodeList(): NzTreeNode[];
    /**
     * return expanded nodes
     */
    getExpandedNodeList(): NzTreeNode[];
    /**
     * return search matched nodes
     */
    getMatchedNodeList(): NzTreeNode[];
    isArrayOfNzTreeNode(value: any[]): boolean;
    /**
     * reset selectedNodeList
     */
    calcSelectedKeys(selectedKeys: string[], nzNodes: NzTreeNode[], isMulti?: boolean): void;
    /**
     * reset expandedNodeList
     */
    calcExpandedKeys(expandedKeys: string[], nzNodes: NzTreeNode[]): void;
    /**
     * reset checkedNodeList
     */
    calcCheckedKeys(checkedKeys: string[], nzNodes: NzTreeNode[], isCheckStrictly?: boolean): void;
    /**
     * set drag node
     */
    setSelectedNode(node: NzTreeNode): void;
    /**
     * set node selected status
     */
    setNodeActive(node: NzTreeNode): void;
    /**
     * add or remove node to selectedNodeList
     */
    setSelectedNodeList(node: NzTreeNode, isMultiple?: boolean): void;
    /**
     * merge checked nodes
     */
    setHalfCheckedNodeList(node: NzTreeNode): void;
    setCheckedNodeList(node: NzTreeNode): void;
    /**
     * conduct checked/selected/expanded keys
     */
    conductNodeState(type?: string): NzTreeNode[];
    /**
     * set expanded nodes
     */
    setExpandedNodeList(node: NzTreeNode): void;
    /**
     * check state
     * @param isCheckStrictly
     */
    refreshCheckState(isCheckStrictly?: boolean): void;
    conduct(node: NzTreeNode): void;
    /**
     * 1、children half checked
     * 2、children all checked, parent checked
     * 3、no children checked
     */
    conductUp(node: NzTreeNode): void;
    /**
     * reset child check state
     */
    conductDown(node: NzTreeNode, value: boolean): void;
    /**
     * search value & expand node
     * should add expandlist
     */
    searchExpand(value: string): void;
    /**
     * flush after delete node
     */
    afterRemove(nodes: NzTreeNode[]): void;
    /**
     * drag event
     */
    refreshDragNode(node: NzTreeNode): void;
    resetNodeLevel(node: NzTreeNode): void;
    calcDropPosition(event: DragEvent): number;
    /**
     * drop
     * 0: inner -1: pre 1: next
     */
    dropAndApply(targetNode: NzTreeNode, dragPos?: number): void;
    /**
     * emit Structure
     * eventName
     * node
     * event: MouseEvent / DragEvent
     * dragNode
     */
    formatEvent(eventName: string, node: NzTreeNode | null, event: MouseEvent | DragEvent | null): NzFormatEmitEvent;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTreeBaseService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzTreeBaseService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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