/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, EventEmitter, OnChanges, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { CandyDate, FunctionProp, NzNoAnimationDirective } from 'ng-zorro-antd/core';
import { DateHelperService, NzI18nService } from 'ng-zorro-antd/i18n';
import { AbstractPickerComponent } from './abstract-picker.component';
import { DisabledTimeFn, PanelMode, PresetRanges } from './standard-types';
import * as ɵngcc0 from '@angular/core';
export declare class DateRangePickerComponent extends AbstractPickerComponent implements OnInit, OnChanges {
    showWeek: boolean;
    nzDateRender: FunctionProp<TemplateRef<Date> | string>;
    nzDisabledTime: DisabledTimeFn;
    nzRenderExtraFooter: FunctionProp<TemplateRef<void> | string>;
    nzShowToday: boolean;
    nzMode: PanelMode | PanelMode[];
    nzRanges: PresetRanges;
    readonly nzOnPanelChange: EventEmitter<"decade" | "year" | "month" | "date" | "time" | PanelMode[]>;
    readonly nzOnCalendarChange: EventEmitter<Date[]>;
    private _showTime;
    nzShowTime: object | boolean;
    readonly nzOnOk: EventEmitter<Date | Date[] | null>;
    readonly realShowToday: boolean;
    pickerStyle: object;
    extraFooter: TemplateRef<void> | string;
    constructor(i18n: NzI18nService, cdr: ChangeDetectorRef, dateHelper: DateHelperService, noAnimation?: NzNoAnimationDirective);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    /**
     * If user press 'Enter' in input box or `nzShowTime` is false, overlay will close.
     */
    onValueChange(value: CandyDate, isEnter?: boolean): void;
    onCalendarChange(value: CandyDate[]): void;
    onResultOk(): void;
    onOpenChange(open: boolean): void;
    private setFixedPickerStyle;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<DateRangePickerComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<DateRangePickerComponent, "ng-component", never, {
    "nzShowToday": "nzShowToday";
    "nzShowTime": "nzShowTime";
    "nzDateRender": "nzDateRender";
    "nzDisabledTime": "nzDisabledTime";
    "nzRenderExtraFooter": "nzRenderExtraFooter";
    "nzMode": "nzMode";
    "nzRanges": "nzRanges";
}, {
    "nzOnPanelChange": "nzOnPanelChange";
    "nzOnCalendarChange": "nzOnCalendarChange";
    "nzOnOk": "nzOnOk";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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