/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export interface PaginationItemRenderContext {
    $implicit: 'page' | 'prev' | 'next';
    page: number;
}
export declare class NzPaginationComponent implements OnInit, OnDestroy, OnChanges {
    private i18n;
    private cdr;
    locale: any;
    firstIndex: number;
    pages: number[];
    private $destroy;
    readonly nzPageSizeChange: EventEmitter<number>;
    readonly nzPageIndexChange: EventEmitter<number>;
    nzShowTotal: TemplateRef<{
        $implicit: number;
        range: [number, number];
    }>;
    nzInTable: boolean;
    nzSize: 'default' | 'small';
    nzPageSizeOptions: number[];
    nzItemRender: TemplateRef<PaginationItemRenderContext>;
    nzItemRenderChild: TemplateRef<PaginationItemRenderContext>;
    readonly itemRender: TemplateRef<PaginationItemRenderContext>;
    nzDisabled: boolean;
    nzShowSizeChanger: boolean;
    nzHideOnSinglePage: boolean;
    nzShowQuickJumper: boolean;
    nzSimple: boolean;
    nzTotal: number;
    nzPageIndex: number;
    nzPageSize: number;
    validatePageIndex(value: number): number;
    updatePageIndexValue(page: number): void;
    isPageIndexValid(value: number): boolean;
    jumpPage(index: number): void;
    jumpDiff(diff: number): void;
    onPageSizeChange($event: number): void;
    handleKeyDown(_: KeyboardEvent, input: HTMLInputElement, clearInputValue: boolean): void;
    /** generate indexes list */
    buildIndexes(): void;
    readonly lastIndex: number;
    readonly isLastIndex: boolean;
    readonly isFirstIndex: boolean;
    readonly ranges: number[];
    readonly showAddOption: boolean;
    constructor(i18n: NzI18nService, cdr: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: SimpleChanges): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzPaginationComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzPaginationComponent, "nz-pagination", ["nzPagination"], {
    "nzInTable": "nzInTable";
    "nzSize": "nzSize";
    "nzPageSizeOptions": "nzPageSizeOptions";
    "nzDisabled": "nzDisabled";
    "nzShowSizeChanger": "nzShowSizeChanger";
    "nzHideOnSinglePage": "nzHideOnSinglePage";
    "nzShowQuickJumper": "nzShowQuickJumper";
    "nzSimple": "nzSimple";
    "nzTotal": "nzTotal";
    "nzPageIndex": "nzPageIndex";
    "nzPageSize": "nzPageSize";
    "nzShowTotal": "nzShowTotal";
    "nzItemRender": "nzItemRender";
}, {
    "nzPageSizeChange": "nzPageSizeChange";
    "nzPageIndexChange": "nzPageIndexChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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