/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay, CdkOverlayOrigin, ConnectedOverlayPositionChange, ConnectionPositionPair } from '@angular/cdk/overlay';
import { AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, SimpleChanges } from '@angular/core';
import { CandyDate } from 'ng-zorro-antd/core';
import { DateHelperService } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class NzPickerComponent implements AfterViewInit, OnChanges {
    private dateHelper;
    private changeDetector;
    noAnimation: boolean;
    isRange: boolean;
    open: boolean | undefined;
    disabled: boolean;
    placeholder: string | string[];
    allowClear: boolean;
    autoFocus: boolean;
    className: string;
    format: string;
    size: 'large' | 'small';
    style: object;
    value: CandyDate | CandyDate[] | null;
    readonly valueChange: EventEmitter<CandyDate | CandyDate[] | null>;
    readonly openChange: EventEmitter<boolean>;
    origin: CdkOverlayOrigin;
    cdkConnectedOverlay: CdkConnectedOverlay;
    pickerInput: ElementRef;
    prefixCls: string;
    animationOpenState: boolean;
    overlayOpen: boolean;
    overlayOffsetY: number;
    overlayOffsetX: number;
    overlayPositions: ConnectionPositionPair[];
    dropdownAnimation: 'top' | 'bottom';
    currentPositionX: 'start' | 'end';
    currentPositionY: 'top' | 'bottom';
    readonly realOpenState: boolean;
    constructor(dateHelper: DateHelperService, changeDetector: ChangeDetectorRef);
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    focus(): void;
    showOverlay(): void;
    hideOverlay(): void;
    onClickInputBox(): void;
    onClickBackdrop(): void;
    onOverlayDetach(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    onClickClear(event: MouseEvent): void;
    getReadableValue(partType?: RangePartType): string | null;
    getPartTypeIndex(partType: RangePartType): number;
    getPlaceholder(partType?: RangePartType): string;
    isEmptyValue(value: CandyDate[] | CandyDate | null): boolean;
    isOpenHandledByUser(): boolean;
    animationStart(): void;
    animationDone(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzPickerComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzPickerComponent, "nz-picker", ["nzPicker"], {
    "noAnimation": "noAnimation";
    "isRange": "isRange";
    "open": "open";
    "value": "value";
    "disabled": "disabled";
    "placeholder": "placeholder";
    "allowClear": "allowClear";
    "autoFocus": "autoFocus";
    "className": "className";
    "format": "format";
    "size": "size";
    "style": "style";
}, {
    "valueChange": "valueChange";
    "openChange": "openChange";
}, never>;
}
export declare type RangePartType = 'left' | 'right';

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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