/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, OnChanges, OnDestroy, SimpleChanges } from '@angular/core';
import { NgStyleInterface } from 'ng-zorro-antd/core';
import { NzTooltipDirective } from 'ng-zorro-antd/tooltip';
import { SliderShowTooltip } from './nz-slider-definitions';
import { NzSliderComponent } from './nz-slider.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzSliderHandleComponent implements OnChanges, OnDestroy {
    private sliderComponent;
    private cdr;
    tooltip: NzTooltipDirective;
    nzVertical: string;
    nzOffset: number;
    nzValue: number;
    nzTooltipVisible: SliderShowTooltip;
    nzTooltipPlacement: string;
    nzTipFormatter: (value: number) => string;
    nzActive: boolean;
    tooltipTitle: string;
    style: NgStyleInterface;
    private hovers_;
    constructor(sliderComponent: NzSliderComponent, cdr: ChangeDetectorRef);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    enterHandle: () => void;
    leaveHandle: () => void;
    private toggleTooltip;
    private updateTooltipTitle;
    private updateTooltipPosition;
    private updateStyle;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSliderHandleComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSliderHandleComponent, "nz-slider-handle", ["nzSliderHandle"], {
    "nzTooltipVisible": "nzTooltipVisible";
    "nzActive": "nzActive";
    "nzVertical": "nzVertical";
    "nzOffset": "nzOffset";
    "nzValue": "nzValue";
    "nzTooltipPlacement": "nzTooltipPlacement";
    "nzTipFormatter": "nzTipFormatter";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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