/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { isDevMode } from '@angular/core';
import { generate as generateColor } from '@ant-design/colors';
/** @type {?} */
export const ANT_ICON_ANGULAR_CONSOLE_PREFIX = '[@ant-design/icons-angular]:';
/**
 * @param {?} message
 * @return {?}
 */
export function error(message) {
    console.error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX} ${message}.`);
}
/**
 * @param {?} message
 * @return {?}
 */
export function warn(message) {
    if (isDevMode()) {
        console.warn(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX} ${message}.`);
    }
}
/**
 * @param {?} primaryColor
 * @return {?}
 */
export function getSecondaryColor(primaryColor) {
    return generateColor(primaryColor)[0];
}
/**
 * @param {?} name
 * @param {?} theme
 * @return {?}
 */
export function withSuffix(name, theme) {
    switch (theme) {
        case 'fill': return `${name}-fill`;
        case 'outline': return `${name}-o`;
        case 'twotone': return `${name}-twotone`;
        case undefined: return name;
        default: throw new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}Theme "${theme}" is not a recognized theme!`);
    }
}
/**
 * @param {?} name
 * @param {?} theme
 * @param {?} pri
 * @param {?} sec
 * @return {?}
 */
export function withSuffixAndColor(name, theme, pri, sec) {
    return `${withSuffix(name, theme)}-${pri}-${sec}`;
}
/**
 * @param {?} abbr
 * @return {?}
 */
export function mapAbbrToTheme(abbr) {
    return abbr === 'o' ? 'outline' : (/** @type {?} */ (abbr));
}
/**
 * @param {?} name
 * @return {?}
 */
export function alreadyHasAThemeSuffix(name) {
    return name.endsWith('-fill') || name.endsWith('-o') || name.endsWith('-twotone');
}
/**
 * @param {?} target
 * @return {?}
 */
export function isIconDefinition(target) {
    return (typeof target === 'object' &&
        typeof target.name === 'string' &&
        (typeof target.theme === 'string' || target.theme === undefined) &&
        typeof target.icon === 'string');
}
/**
 * Get an `IconDefinition` object from abbreviation type, like `account-book-fill`.
 * @param {?} str
 * @return {?}
 */
export function getIconDefinitionFromAbbr(str) {
    /** @type {?} */
    const arr = str.split('-');
    /** @type {?} */
    const theme = mapAbbrToTheme(arr.splice(arr.length - 1, 1)[0]);
    /** @type {?} */
    const name = arr.join('-');
    return (/** @type {?} */ ({
        name,
        theme,
        icon: ''
    }));
}
/**
 * @param {?} svg
 * @return {?}
 */
export function cloneSVG(svg) {
    return (/** @type {?} */ (svg.cloneNode(true)));
}
/**
 * Parse inline SVG string and replace colors with placeholders. For twotone icons only.
 * @param {?} raw
 * @return {?}
 */
export function replaceFillColor(raw) {
    return raw
        .replace(/['"]#333['"]/g, '"primaryColor"')
        .replace(/['"]#E6E6E6['"]/g, '"secondaryColor"')
        .replace(/['"]#D9D9D9['"]/g, '"secondaryColor"')
        .replace(/['"]#D8D8D8['"]/g, '"secondaryColor"');
}
/**
 * Split a name with namespace in it into a tuple like [ name, namespace ].
 * @param {?} type
 * @return {?}
 */
export function getNameAndNamespace(type) {
    /** @type {?} */
    const split = type.split(':');
    switch (split.length) {
        case 1: return [type, ''];
        case 2: return [split[1], split[0]];
        default: throw new Error(`${ANT_ICON_ANGULAR_CONSOLE_PREFIX}The icon type ${type} is not valid!`);
    }
}
/**
 * @param {?} type
 * @return {?}
 */
export function hasNamespace(type) {
    return getNameAndNamespace(type)[1] !== '';
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9AYW50LWRlc2lnbi9pY29ucy1hbmd1bGFyLyIsInNvdXJjZXMiOlsidXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFDMUMsT0FBTyxFQUFFLFFBQVEsSUFBSSxhQUFhLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQzs7QUFJL0QsTUFBTSxPQUFPLCtCQUErQixHQUFHLDhCQUE4Qjs7Ozs7QUFFN0UsTUFBTSxVQUFVLEtBQUssQ0FBQyxPQUFlO0lBQ25DLE9BQU8sQ0FBQyxLQUFLLENBQUMsR0FBRywrQkFBK0IsSUFBSSxPQUFPLEdBQUcsQ0FBQyxDQUFDO0FBQ2xFLENBQUM7Ozs7O0FBRUQsTUFBTSxVQUFVLElBQUksQ0FBQyxPQUFlO0lBQ2xDLElBQUksU0FBUyxFQUFFLEVBQUU7UUFDZixPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsK0JBQStCLElBQUksT0FBTyxHQUFHLENBQUMsQ0FBQztLQUNoRTtBQUNILENBQUM7Ozs7O0FBRUQsTUFBTSxVQUFVLGlCQUFpQixDQUFDLFlBQW9CO0lBQ3BELE9BQU8sYUFBYSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3hDLENBQUM7Ozs7OztBQUVELE1BQU0sVUFBVSxVQUFVLENBQUMsSUFBWSxFQUFFLEtBQTRCO0lBQ25FLFFBQVEsS0FBSyxFQUFFO1FBQ2IsS0FBSyxNQUFNLENBQUMsQ0FBQyxPQUFPLEdBQUcsSUFBSSxPQUFPLENBQUM7UUFDbkMsS0FBSyxTQUFTLENBQUMsQ0FBQyxPQUFPLEdBQUcsSUFBSSxJQUFJLENBQUM7UUFDbkMsS0FBSyxTQUFTLENBQUMsQ0FBQyxPQUFPLEdBQUcsSUFBSSxVQUFVLENBQUM7UUFDekMsS0FBSyxTQUFTLENBQUMsQ0FBQyxPQUFPLElBQUksQ0FBQztRQUM1QixPQUFPLENBQUMsQ0FBQyxNQUFNLElBQUksS0FBSyxDQUFDLEdBQUcsK0JBQStCLFVBQVUsS0FBSyw4QkFBOEIsQ0FBQyxDQUFDO0tBQzNHO0FBQ0gsQ0FBQzs7Ozs7Ozs7QUFFRCxNQUFNLFVBQVUsa0JBQWtCLENBQUMsSUFBWSxFQUFFLEtBQWdCLEVBQUUsR0FBVyxFQUFFLEdBQVc7SUFDekYsT0FBTyxHQUFHLFVBQVUsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUksR0FBRyxJQUFJLEdBQUcsRUFBRSxDQUFDO0FBQ3BELENBQUM7Ozs7O0FBRUQsTUFBTSxVQUFVLGNBQWMsQ0FBQyxJQUFZO0lBQ3pDLE9BQU8sSUFBSSxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxtQkFBQSxJQUFJLEVBQWEsQ0FBQztBQUN0RCxDQUFDOzs7OztBQUVELE1BQU0sVUFBVSxzQkFBc0IsQ0FBQyxJQUFZO0lBQ2pELE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUM7QUFDcEYsQ0FBQzs7Ozs7QUFFRCxNQUFNLFVBQVUsZ0JBQWdCLENBQUMsTUFBK0I7SUFDOUQsT0FBTyxDQUNMLE9BQU8sTUFBTSxLQUFLLFFBQVE7UUFDMUIsT0FBTyxNQUFNLENBQUMsSUFBSSxLQUFLLFFBQVE7UUFDL0IsQ0FBQyxPQUFPLE1BQU0sQ0FBQyxLQUFLLEtBQUssUUFBUSxJQUFJLE1BQU0sQ0FBQyxLQUFLLEtBQUssU0FBUyxDQUFDO1FBQ2hFLE9BQU8sTUFBTSxDQUFDLElBQUksS0FBSyxRQUFRLENBQ2hDLENBQUM7QUFDSixDQUFDOzs7Ozs7QUFNRCxNQUFNLFVBQVUseUJBQXlCLENBQUMsR0FBVzs7VUFDN0MsR0FBRyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDOztVQUNwQixLQUFLLEdBQUcsY0FBYyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O1VBQ3hELElBQUksR0FBRyxHQUFHLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUUxQixPQUFPLG1CQUFBO1FBQ0wsSUFBSTtRQUNKLEtBQUs7UUFDTCxJQUFJLEVBQUUsRUFBRTtLQUNULEVBQWtCLENBQUM7QUFDdEIsQ0FBQzs7Ozs7QUFFRCxNQUFNLFVBQVUsUUFBUSxDQUFDLEdBQWU7SUFDdEMsT0FBTyxtQkFBQSxHQUFHLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFjLENBQUM7QUFDM0MsQ0FBQzs7Ozs7O0FBS0QsTUFBTSxVQUFVLGdCQUFnQixDQUFDLEdBQVc7SUFDMUMsT0FBTyxHQUFHO1NBQ1AsT0FBTyxDQUFDLGVBQWUsRUFBRSxnQkFBZ0IsQ0FBQztTQUMxQyxPQUFPLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLENBQUM7U0FDL0MsT0FBTyxDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixDQUFDO1NBQy9DLE9BQU8sQ0FBQyxrQkFBa0IsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDO0FBQ3JELENBQUM7Ozs7OztBQUtELE1BQU0sVUFBVSxtQkFBbUIsQ0FBQyxJQUFZOztVQUN4QyxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUM7SUFDN0IsUUFBUSxLQUFLLENBQUMsTUFBTSxFQUFFO1FBQ3BCLEtBQUssQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUMxQixLQUFLLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDcEMsT0FBTyxDQUFDLENBQUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxHQUFHLCtCQUErQixpQkFBaUIsSUFBSSxnQkFBZ0IsQ0FBQyxDQUFDO0tBQ25HO0FBQ0gsQ0FBQzs7Ozs7QUFFRCxNQUFNLFVBQVUsWUFBWSxDQUFDLElBQVk7SUFDdkMsT0FBTyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUM7QUFDN0MsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGlzRGV2TW9kZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgZ2VuZXJhdGUgYXMgZ2VuZXJhdGVDb2xvciB9IGZyb20gJ0BhbnQtZGVzaWduL2NvbG9ycyc7XG5cbmltcG9ydCB7IEljb25EZWZpbml0aW9uLCBUaGVtZVR5cGUgfSBmcm9tICcuL3R5cGVzJztcblxuZXhwb3J0IGNvbnN0IEFOVF9JQ09OX0FOR1VMQVJfQ09OU09MRV9QUkVGSVggPSAnW0BhbnQtZGVzaWduL2ljb25zLWFuZ3VsYXJdOic7XG5cbmV4cG9ydCBmdW5jdGlvbiBlcnJvcihtZXNzYWdlOiBzdHJpbmcpOiB2b2lkIHtcbiAgY29uc29sZS5lcnJvcihgJHtBTlRfSUNPTl9BTkdVTEFSX0NPTlNPTEVfUFJFRklYfSAke21lc3NhZ2V9LmApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gd2FybihtZXNzYWdlOiBzdHJpbmcpOiB2b2lkIHtcbiAgaWYgKGlzRGV2TW9kZSgpKSB7XG4gICAgY29uc29sZS53YXJuKGAke0FOVF9JQ09OX0FOR1VMQVJfQ09OU09MRV9QUkVGSVh9ICR7bWVzc2FnZX0uYCk7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldFNlY29uZGFyeUNvbG9yKHByaW1hcnlDb2xvcjogc3RyaW5nKTogc3RyaW5nIHtcbiAgcmV0dXJuIGdlbmVyYXRlQ29sb3IocHJpbWFyeUNvbG9yKVswXTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHdpdGhTdWZmaXgobmFtZTogc3RyaW5nLCB0aGVtZTogVGhlbWVUeXBlIHwgdW5kZWZpbmVkKTogc3RyaW5nIHtcbiAgc3dpdGNoICh0aGVtZSkge1xuICAgIGNhc2UgJ2ZpbGwnOiByZXR1cm4gYCR7bmFtZX0tZmlsbGA7XG4gICAgY2FzZSAnb3V0bGluZSc6IHJldHVybiBgJHtuYW1lfS1vYDtcbiAgICBjYXNlICd0d290b25lJzogcmV0dXJuIGAke25hbWV9LXR3b3RvbmVgO1xuICAgIGNhc2UgdW5kZWZpbmVkOiByZXR1cm4gbmFtZTtcbiAgICBkZWZhdWx0OiB0aHJvdyBuZXcgRXJyb3IoYCR7QU5UX0lDT05fQU5HVUxBUl9DT05TT0xFX1BSRUZJWH1UaGVtZSBcIiR7dGhlbWV9XCIgaXMgbm90IGEgcmVjb2duaXplZCB0aGVtZSFgKTtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gd2l0aFN1ZmZpeEFuZENvbG9yKG5hbWU6IHN0cmluZywgdGhlbWU6IFRoZW1lVHlwZSwgcHJpOiBzdHJpbmcsIHNlYzogc3RyaW5nKTogc3RyaW5nIHtcbiAgcmV0dXJuIGAke3dpdGhTdWZmaXgobmFtZSwgdGhlbWUpfS0ke3ByaX0tJHtzZWN9YDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1hcEFiYnJUb1RoZW1lKGFiYnI6IHN0cmluZyk6IFRoZW1lVHlwZSB7XG4gIHJldHVybiBhYmJyID09PSAnbycgPyAnb3V0bGluZScgOiBhYmJyIGFzIFRoZW1lVHlwZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFscmVhZHlIYXNBVGhlbWVTdWZmaXgobmFtZTogc3RyaW5nKTogYm9vbGVhbiB7XG4gIHJldHVybiBuYW1lLmVuZHNXaXRoKCctZmlsbCcpIHx8IG5hbWUuZW5kc1dpdGgoJy1vJykgfHwgbmFtZS5lbmRzV2l0aCgnLXR3b3RvbmUnKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzSWNvbkRlZmluaXRpb24odGFyZ2V0OiBzdHJpbmcgfCBJY29uRGVmaW5pdGlvbik6IHRhcmdldCBpcyBJY29uRGVmaW5pdGlvbiB7XG4gIHJldHVybiAoXG4gICAgdHlwZW9mIHRhcmdldCA9PT0gJ29iamVjdCcgJiZcbiAgICB0eXBlb2YgdGFyZ2V0Lm5hbWUgPT09ICdzdHJpbmcnICYmXG4gICAgKHR5cGVvZiB0YXJnZXQudGhlbWUgPT09ICdzdHJpbmcnIHx8IHRhcmdldC50aGVtZSA9PT0gdW5kZWZpbmVkKSAmJlxuICAgIHR5cGVvZiB0YXJnZXQuaWNvbiA9PT0gJ3N0cmluZydcbiAgKTtcbn1cblxuLyoqXG4gKiBHZXQgYW4gYEljb25EZWZpbml0aW9uYCBvYmplY3QgZnJvbSBhYmJyZXZpYXRpb24gdHlwZSwgbGlrZSBgYWNjb3VudC1ib29rLWZpbGxgLlxuICogQHBhcmFtIHN0clxuICovXG5leHBvcnQgZnVuY3Rpb24gZ2V0SWNvbkRlZmluaXRpb25Gcm9tQWJicihzdHI6IHN0cmluZyk6IEljb25EZWZpbml0aW9uIHtcbiAgY29uc3QgYXJyID0gc3RyLnNwbGl0KCctJyk7XG4gIGNvbnN0IHRoZW1lID0gbWFwQWJiclRvVGhlbWUoYXJyLnNwbGljZShhcnIubGVuZ3RoIC0gMSwgMSlbMF0pO1xuICBjb25zdCBuYW1lID0gYXJyLmpvaW4oJy0nKTtcblxuICByZXR1cm4ge1xuICAgIG5hbWUsXG4gICAgdGhlbWUsXG4gICAgaWNvbjogJydcbiAgfSBhcyBJY29uRGVmaW5pdGlvbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNsb25lU1ZHKHN2ZzogU1ZHRWxlbWVudCk6IFNWR0VsZW1lbnQge1xuICByZXR1cm4gc3ZnLmNsb25lTm9kZSh0cnVlKSBhcyBTVkdFbGVtZW50O1xufVxuXG4vKipcbiAqIFBhcnNlIGlubGluZSBTVkcgc3RyaW5nIGFuZCByZXBsYWNlIGNvbG9ycyB3aXRoIHBsYWNlaG9sZGVycy4gRm9yIHR3b3RvbmUgaWNvbnMgb25seS5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHJlcGxhY2VGaWxsQ29sb3IocmF3OiBzdHJpbmcpOiBzdHJpbmcge1xuICByZXR1cm4gcmF3XG4gICAgLnJlcGxhY2UoL1snXCJdIzMzM1snXCJdL2csICdcInByaW1hcnlDb2xvclwiJylcbiAgICAucmVwbGFjZSgvWydcIl0jRTZFNkU2WydcIl0vZywgJ1wic2Vjb25kYXJ5Q29sb3JcIicpXG4gICAgLnJlcGxhY2UoL1snXCJdI0Q5RDlEOVsnXCJdL2csICdcInNlY29uZGFyeUNvbG9yXCInKVxuICAgIC5yZXBsYWNlKC9bJ1wiXSNEOEQ4RDhbJ1wiXS9nLCAnXCJzZWNvbmRhcnlDb2xvclwiJyk7XG59XG5cbi8qKlxuICogU3BsaXQgYSBuYW1lIHdpdGggbmFtZXNwYWNlIGluIGl0IGludG8gYSB0dXBsZSBsaWtlIFsgbmFtZSwgbmFtZXNwYWNlIF0uXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBnZXROYW1lQW5kTmFtZXNwYWNlKHR5cGU6IHN0cmluZyk6IFtzdHJpbmcsIHN0cmluZ10ge1xuICBjb25zdCBzcGxpdCA9IHR5cGUuc3BsaXQoJzonKTtcbiAgc3dpdGNoIChzcGxpdC5sZW5ndGgpIHtcbiAgICBjYXNlIDE6IHJldHVybiBbdHlwZSwgJyddO1xuICAgIGNhc2UgMjogcmV0dXJuIFtzcGxpdFsxXSwgc3BsaXRbMF1dO1xuICAgIGRlZmF1bHQ6IHRocm93IG5ldyBFcnJvcihgJHtBTlRfSUNPTl9BTkdVTEFSX0NPTlNPTEVfUFJFRklYfVRoZSBpY29uIHR5cGUgJHt0eXBlfSBpcyBub3QgdmFsaWQhYCk7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGhhc05hbWVzcGFjZSh0eXBlOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgcmV0dXJuIGdldE5hbWVBbmROYW1lc3BhY2UodHlwZSlbMV0gIT09ICcnO1xufVxuIl19