/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { RendererFactory2 } from '@angular/core';
import { Observable } from 'rxjs';
import * as ɵngcc0 from '@angular/core';
interface Point {
    x: number;
    y: number;
}
declare type Delta = Point;
/**
 * This module provide a global dragging service to other components.
 */
export declare class NzDragService {
    private draggingThreshold;
    private currentDraggingSequence;
    private currentStartingPoint;
    private handleRegistry;
    private renderer;
    constructor(rendererFactory2: RendererFactory2);
    requestDraggingSequence(event: MouseEvent | TouchEvent): Observable<Delta>;
    private registerDraggingHandler;
    private teardownDraggingSequence;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzDragService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzDragService>;
}
export {};

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotZHJhZy5zZXJ2aWNlLmQudHMiLCJzb3VyY2VzIjpbIm56LWRyYWcuc2VydmljZS5kLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7OztBQUNBO0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmltcG9ydCB7IFJlbmRlcmVyRmFjdG9yeTIgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE9ic2VydmFibGUgfSBmcm9tICdyeGpzJztcbmludGVyZmFjZSBQb2ludCB7XG4gICAgeDogbnVtYmVyO1xuICAgIHk6IG51bWJlcjtcbn1cbmRlY2xhcmUgdHlwZSBEZWx0YSA9IFBvaW50O1xuLyoqXG4gKiBUaGlzIG1vZHVsZSBwcm92aWRlIGEgZ2xvYmFsIGRyYWdnaW5nIHNlcnZpY2UgdG8gb3RoZXIgY29tcG9uZW50cy5cbiAqL1xuZXhwb3J0IGRlY2xhcmUgY2xhc3MgTnpEcmFnU2VydmljZSB7XG4gICAgcHJpdmF0ZSBkcmFnZ2luZ1RocmVzaG9sZDtcbiAgICBwcml2YXRlIGN1cnJlbnREcmFnZ2luZ1NlcXVlbmNlO1xuICAgIHByaXZhdGUgY3VycmVudFN0YXJ0aW5nUG9pbnQ7XG4gICAgcHJpdmF0ZSBoYW5kbGVSZWdpc3RyeTtcbiAgICBwcml2YXRlIHJlbmRlcmVyO1xuICAgIGNvbnN0cnVjdG9yKHJlbmRlcmVyRmFjdG9yeTI6IFJlbmRlcmVyRmFjdG9yeTIpO1xuICAgIHJlcXVlc3REcmFnZ2luZ1NlcXVlbmNlKGV2ZW50OiBNb3VzZUV2ZW50IHwgVG91Y2hFdmVudCk6IE9ic2VydmFibGU8RGVsdGE+O1xuICAgIHByaXZhdGUgcmVnaXN0ZXJEcmFnZ2luZ0hhbmRsZXI7XG4gICAgcHJpdmF0ZSB0ZWFyZG93bkRyYWdnaW5nU2VxdWVuY2U7XG59XG5leHBvcnQge307XG4iXX0=