/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { DateHelperService, NzCalendarI18nInterface } from 'ng-zorro-antd/i18n';
import { CandyDate } from 'ng-zorro-antd/core';
import { PanelMode } from '../../standard-types';
import * as ɵngcc0 from '@angular/core';
export declare class CalendarHeaderComponent implements OnInit, OnChanges {
    private dateHelper;
    locale: NzCalendarI18nInterface;
    enablePrev: boolean;
    enableNext: boolean;
    disabledMonth: (date: Date) => boolean;
    disabledYear: (date: Date) => boolean;
    showTimePicker: boolean;
    value: CandyDate;
    readonly valueChange: EventEmitter<CandyDate>;
    panelMode: PanelMode;
    readonly panelModeChange: EventEmitter<PanelMode>;
    readonly chooseDecade: EventEmitter<CandyDate>;
    readonly chooseYear: EventEmitter<CandyDate>;
    readonly chooseMonth: EventEmitter<CandyDate>;
    prefixCls: string;
    yearMonthDaySelectors: YearMonthDaySelector[];
    private yearToMonth;
    constructor(dateHelper: DateHelperService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    previousYear(): void;
    nextYear(): void;
    previousMonth(): void;
    nextMonth(): void;
    changePanel(mode: PanelMode, value?: CandyDate): void;
    onChooseDecade(value: CandyDate): void;
    onChooseYear(value: CandyDate): void;
    onChooseMonth(value: CandyDate): void;
    changeToMonthPanel(): void;
    private render;
    private gotoMonth;
    private gotoYear;
    private changeValueFromInside;
    private formatDateTime;
    private createYearMonthDaySelectors;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<CalendarHeaderComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<CalendarHeaderComponent, "calendar-header", ["calendarHeader"], {
    "enablePrev": "enablePrev";
    "enableNext": "enableNext";
    "showTimePicker": "showTimePicker";
    "value": "value";
    "locale": "locale";
    "disabledMonth": "disabledMonth";
    "disabledYear": "disabledYear";
    "panelMode": "panelMode";
}, {
    "valueChange": "valueChange";
    "panelModeChange": "panelModeChange";
    "chooseDecade": "chooseDecade";
    "chooseYear": "chooseYear";
    "chooseMonth": "chooseMonth";
}, never>;
}
export interface YearMonthDaySelector {
    className: string;
    title?: string;
    label: string;
    onClick?(): void;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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