/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { ChangeDetectorRef, ElementRef, OnChanges } from '@angular/core';
import { NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { ShowUploadListInterface, UploadFile, UploadListType } from './interface';
import * as ɵngcc0 from '@angular/core';
export declare class NzUploadListComponent implements OnChanges {
    private el;
    private cdr;
    private updateHostClassService;
    private platform;
    private imageTypes;
    private _items;
    readonly showPic: boolean;
    locale: any;
    listType: UploadListType;
    items: UploadFile[];
    icons: ShowUploadListInterface;
    onPreview: (file: UploadFile) => void;
    onRemove: (file: UploadFile) => void;
    private prefixCls;
    private setClassMap;
    private extname;
    isImageUrl(file: UploadFile): boolean;
    private previewFile;
    private genThumb;
    showPreview(file: UploadFile): boolean;
    handlePreview(file: UploadFile, e: Event): void;
    handleRemove(file: UploadFile, e: Event): void;
    constructor(el: ElementRef, cdr: ChangeDetectorRef, updateHostClassService: NzUpdateHostClassService, platform: Platform);
    detectChanges(): void;
    ngOnChanges(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzUploadListComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzUploadListComponent, "nz-upload-list", ["nzUploadList"], {
    "locale": "locale";
    "items": "items";
    "listType": "listType";
    "icons": "icons";
    "onPreview": "onPreview";
    "onRemove": "onRemove";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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