/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, Renderer2, SimpleChanges } from '@angular/core';
import { NzConfigService, NzShapeSCType, NzSizeLDSType, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzAvatarComponent implements OnChanges {
    nzConfigService: NzConfigService;
    private elementRef;
    private cd;
    private updateHostClassService;
    private renderer;
    private platform;
    nzShape: NzShapeSCType;
    nzSize: NzSizeLDSType | number;
    nzText: string;
    nzSrc: string;
    nzSrcSet: string;
    nzAlt: string;
    nzIcon: string;
    readonly nzError: EventEmitter<Event>;
    oldAPIIcon: boolean;
    hasText: boolean;
    hasSrc: boolean;
    hasIcon: boolean;
    textStyles: {};
    textEl: ElementRef;
    private el;
    private prefixCls;
    private sizeMap;
    constructor(nzConfigService: NzConfigService, elementRef: ElementRef, cd: ChangeDetectorRef, updateHostClassService: NzUpdateHostClassService, renderer: Renderer2, platform: Platform);
    setClass(): this;
    imgError($event: Event): void;
    ngOnChanges(changes: SimpleChanges): void;
    private calcStringSize;
    private notifyCalc;
    private setSizeStyle;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAvatarComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAvatarComponent, "nz-avatar", ["nzAvatar"], {
    "nzShape": "nzShape";
    "nzSize": "nzSize";
    "nzText": "nzText";
    "nzSrc": "nzSrc";
    "nzSrcSet": "nzSrcSet";
    "nzAlt": "nzAlt";
    "nzIcon": "nzIcon";
}, {
    "nzError": "nzError";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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