/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ConnectedOverlayPositionChange } from '@angular/cdk/overlay';
import { ChangeDetectorRef, OnDestroy, TemplateRef } from '@angular/core';
import { Observable } from 'rxjs';
import { NzDropdownService } from './nz-dropdown.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzDropdownContextComponent implements OnDestroy {
    private cdr;
    open: boolean;
    templateRef: TemplateRef<void>;
    dropDownPosition: 'top' | 'bottom';
    private control;
    private destroy$;
    init(open: boolean, templateRef: TemplateRef<void>, positionChanges: Observable<ConnectedOverlayPositionChange>, control: NzDropdownService): void;
    close(): void;
    afterAnimation(): void;
    constructor(cdr: ChangeDetectorRef);
    /** https://github.com/angular/angular/issues/14842 **/
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzDropdownContextComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzDropdownContextComponent, "nz-dropdown-context", ["nzDropdownContext"], {}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotZHJvcGRvd24tY29udGV4dC5jb21wb25lbnQuZC50cyIsInNvdXJjZXMiOlsibnotZHJvcGRvd24tY29udGV4dC5jb21wb25lbnQuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7QUFDQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBBbGliYWJhLmNvbSBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vZ2l0aHViLmNvbS9ORy1aT1JSTy9uZy16b3Jyby1hbnRkL2Jsb2IvbWFzdGVyL0xJQ0VOU0VcbiAqL1xuaW1wb3J0IHsgQ29ubmVjdGVkT3ZlcmxheVBvc2l0aW9uQ2hhbmdlIH0gZnJvbSAnQGFuZ3VsYXIvY2RrL292ZXJsYXknO1xuaW1wb3J0IHsgQ2hhbmdlRGV0ZWN0b3JSZWYsIE9uRGVzdHJveSwgVGVtcGxhdGVSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE9ic2VydmFibGUgfSBmcm9tICdyeGpzJztcbmltcG9ydCB7IE56RHJvcGRvd25TZXJ2aWNlIH0gZnJvbSAnLi9uei1kcm9wZG93bi5zZXJ2aWNlJztcbmV4cG9ydCBkZWNsYXJlIGNsYXNzIE56RHJvcGRvd25Db250ZXh0Q29tcG9uZW50IGltcGxlbWVudHMgT25EZXN0cm95IHtcbiAgICBwcml2YXRlIGNkcjtcbiAgICBvcGVuOiBib29sZWFuO1xuICAgIHRlbXBsYXRlUmVmOiBUZW1wbGF0ZVJlZjx2b2lkPjtcbiAgICBkcm9wRG93blBvc2l0aW9uOiAndG9wJyB8ICdib3R0b20nO1xuICAgIHByaXZhdGUgY29udHJvbDtcbiAgICBwcml2YXRlIGRlc3Ryb3kkO1xuICAgIGluaXQob3BlbjogYm9vbGVhbiwgdGVtcGxhdGVSZWY6IFRlbXBsYXRlUmVmPHZvaWQ+LCBwb3NpdGlvbkNoYW5nZXM6IE9ic2VydmFibGU8Q29ubmVjdGVkT3ZlcmxheVBvc2l0aW9uQ2hhbmdlPiwgY29udHJvbDogTnpEcm9wZG93blNlcnZpY2UpOiB2b2lkO1xuICAgIGNsb3NlKCk6IHZvaWQ7XG4gICAgYWZ0ZXJBbmltYXRpb24oKTogdm9pZDtcbiAgICBjb25zdHJ1Y3RvcihjZHI6IENoYW5nZURldGVjdG9yUmVmKTtcbiAgICAvKiogaHR0cHM6Ly9naXRodWIuY29tL2FuZ3VsYXIvYW5ndWxhci9pc3N1ZXMvMTQ4NDIgKiovXG4gICAgbmdPbkRlc3Ryb3koKTogdm9pZDtcbn1cbiJdfQ==