/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, OnDestroy, OnInit } from '@angular/core';
import { NzMessageContainerComponent } from './nz-message-container.component';
import { NzMessageDataFilled, NzMessageDataOptions } from './nz-message.definitions';
import * as ɵngcc0 from '@angular/core';
export declare class NzMessageComponent implements OnInit, OnDestroy {
    private _messageContainer;
    protected cdr: ChangeDetectorRef;
    nzMessage: NzMessageDataFilled;
    nzIndex: number;
    protected _options: Required<NzMessageDataOptions>;
    private _autoErase;
    private _eraseTimer;
    private _eraseTimingStart;
    private _eraseTTL;
    constructor(_messageContainer: NzMessageContainerComponent, cdr: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnDestroy(): void;
    onEnter(): void;
    onLeave(): void;
    protected _destroy(userAction?: boolean): void;
    private _initErase;
    private _updateTTL;
    private _startEraseTimeout;
    private _clearEraseTimeout;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzMessageComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzMessageComponent, "nz-message", ["nzMessage"], {
    "nzMessage": "nzMessage";
    "nzIndex": "nzIndex";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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