/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { CdkConnectedOverlay, ConnectedOverlayPositionChange, ConnectionPositionPair } from '@angular/cdk/overlay';
import { ChangeDetectorRef, ElementRef, EventEmitter, OnDestroy, OnInit, QueryList, Renderer2, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NgClassType, NgStyleInterface, NzConfigService, NzNoAnimationDirective } from 'ng-zorro-antd/core';
import { NzCascaderI18nInterface, NzI18nService } from 'ng-zorro-antd/i18n';
import { NzCascaderComponentAsSource, NzCascaderExpandTrigger, NzCascaderOption, NzCascaderSize, NzCascaderTriggerType, NzShowSearchOptions } from './nz-cascader-definitions';
import { NzCascaderOptionComponent } from './nz-cascader-li.component';
import { NzCascaderService } from './nz-cascader.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzCascaderComponent implements NzCascaderComponentAsSource, OnInit, OnDestroy, ControlValueAccessor {
    cascaderService: NzCascaderService;
    private i18nService;
    nzConfigService: NzConfigService;
    private cdr;
    noAnimation?: NzNoAnimationDirective | undefined;
    input: ElementRef;
    menu: ElementRef;
    overlay: CdkConnectedOverlay;
    cascaderItems: QueryList<NzCascaderOptionComponent>;
    nzOptionRender: TemplateRef<{
        $implicit: NzCascaderOption;
        index: number;
    }> | null;
    nzShowInput: boolean;
    nzShowArrow: boolean;
    nzAllowClear: boolean;
    nzAutoFocus: boolean;
    nzChangeOnSelect: boolean;
    nzDisabled: boolean;
    nzColumnClassName: string;
    nzExpandTrigger: NzCascaderExpandTrigger;
    nzValueProperty: string;
    nzLabelRender: TemplateRef<void>;
    nzLabelProperty: string;
    nzNotFoundContent: string | TemplateRef<void>;
    nzSize: NzCascaderSize;
    nzShowSearch: boolean | NzShowSearchOptions;
    nzPlaceHolder: string;
    nzMenuClassName: string;
    nzMenuStyle: NgStyleInterface;
    nzMouseEnterDelay: number;
    nzMouseLeaveDelay: number;
    nzTriggerAction: NzCascaderTriggerType | NzCascaderTriggerType[];
    nzChangeOn: (option: NzCascaderOption, level: number) => boolean;
    nzLoadData: (node: NzCascaderOption, index?: number) => PromiseLike<any>;
    nzOptions: NzCascaderOption[] | null;
    readonly nzVisibleChange: EventEmitter<boolean>;
    readonly nzSelectionChange: EventEmitter<import("./nz-cascader-definitions").CascaderOption[]>;
    /**
     * @deprecated 9.0.0. This api is a duplication of `ngModelChange`.
     */
    readonly nzSelect: EventEmitter<{
        option: import("./nz-cascader-definitions").CascaderOption;
        index: number;
    } | null>;
    readonly nzClear: EventEmitter<void>;
    el: HTMLElement;
    dropDownPosition: string;
    menuVisible: boolean;
    isLoading: boolean;
    labelRenderText: string;
    labelRenderContext: {};
    onChange: Function;
    onTouched: Function;
    positions: ConnectionPositionPair[];
    dropdownWidthStyle: string;
    isFocused: boolean;
    locale: NzCascaderI18nInterface;
    private $destroy;
    private inputString;
    private isOpening;
    private delayMenuTimer;
    private delaySelectTimer;
    readonly inSearchingMode: boolean;
    inputValue: string;
    readonly menuCls: NgClassType;
    readonly menuColumnCls: NgClassType;
    private readonly hasInput;
    private readonly hasValue;
    readonly showPlaceholder: boolean;
    readonly clearIconVisible: boolean;
    readonly isLabelRenderTemplate: boolean;
    constructor(cascaderService: NzCascaderService, i18nService: NzI18nService, nzConfigService: NzConfigService, cdr: ChangeDetectorRef, elementRef: ElementRef, renderer: Renderer2, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnInit(): void;
    ngOnDestroy(): void;
    registerOnChange(fn: () => {}): void;
    registerOnTouched(fn: () => {}): void;
    writeValue(value: any): void;
    delaySetMenuVisible(visible: boolean, delay?: number, setOpening?: boolean): void;
    setMenuVisible(visible: boolean): void;
    private clearDelayMenuTimer;
    clearSelection(event?: Event): void;
    getSubmitValue(): any[];
    focus(): void;
    blur(): void;
    handleInputBlur(): void;
    handleInputFocus(): void;
    onKeyDown(event: KeyboardEvent): void;
    onTriggerClick(): void;
    onTriggerMouseEnter(): void;
    onTriggerMouseLeave(event: MouseEvent): void;
    onOptionMouseEnter(option: NzCascaderOption, columnIndex: number, event: Event): void;
    onOptionMouseLeave(option: NzCascaderOption, _columnIndex: number, event: Event): void;
    onOptionClick(option: NzCascaderOption, columnIndex: number, event: Event): void;
    private isActionTrigger;
    private onEnter;
    private moveUpOrDown;
    private moveLeft;
    private moveRight;
    private clearDelaySelectTimer;
    private delaySetOptionActivated;
    private toggleSearchingMode;
    isOptionActivated(option: NzCascaderOption, index: number): boolean;
    setDisabledState(isDisabled: boolean): void;
    closeMenu(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    /**
     * Reposition the cascader panel. When a menu opens, the cascader expands
     * and may exceed the boundary of browser's window.
     */
    private reposition;
    /**
     * When a cascader options is changed, a child needs to know that it should re-render.
     */
    private checkChildren;
    private buildDisplayLabel;
    private setLocale;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzCascaderComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzCascaderComponent, "nz-cascader, [nz-cascader]", ["nzCascader"], {
    "nzOptionRender": "nzOptionRender";
    "nzShowInput": "nzShowInput";
    "nzShowArrow": "nzShowArrow";
    "nzAllowClear": "nzAllowClear";
    "nzAutoFocus": "nzAutoFocus";
    "nzChangeOnSelect": "nzChangeOnSelect";
    "nzDisabled": "nzDisabled";
    "nzExpandTrigger": "nzExpandTrigger";
    "nzValueProperty": "nzValueProperty";
    "nzLabelProperty": "nzLabelProperty";
    "nzMouseEnterDelay": "nzMouseEnterDelay";
    "nzMouseLeaveDelay": "nzMouseLeaveDelay";
    "nzTriggerAction": "nzTriggerAction";
    "nzOptions": "nzOptions";
    "nzColumnClassName": "nzColumnClassName";
    "nzLabelRender": "nzLabelRender";
    "nzNotFoundContent": "nzNotFoundContent";
    "nzSize": "nzSize";
    "nzShowSearch": "nzShowSearch";
    "nzPlaceHolder": "nzPlaceHolder";
    "nzMenuClassName": "nzMenuClassName";
    "nzMenuStyle": "nzMenuStyle";
    "nzChangeOn": "nzChangeOn";
    "nzLoadData": "nzLoadData";
}, {
    "nzVisibleChange": "nzVisibleChange";
    "nzSelectionChange": "nzSelectionChange";
    "nzSelect": "nzSelect";
    "nzClear": "nzClear";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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