/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { FocusTrapFactory } from '@angular/cdk/a11y';
import { Overlay, OverlayKeyboardDispatcher, OverlayRef } from '@angular/cdk/overlay';
import { AfterViewInit, ChangeDetectorRef, ComponentFactoryResolver, ComponentRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef, Type, ViewContainerRef } from '@angular/core';
import { Observable } from 'rxjs';
import { NzConfigService } from 'ng-zorro-antd/core';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import { NzModalConfig } from './nz-modal-config';
import { NzModalControlService } from './nz-modal-control.service';
import { NzModalFooterDirective } from './nz-modal-footer.directive';
import { NzModalRef } from './nz-modal-ref.class';
import { ModalButtonOptions, ModalOptions, ModalType, OnClickCallback } from './nz-modal.type';
import * as ɵngcc0 from '@angular/core';
export declare const MODAL_ANIMATE_DURATION = 200;
export declare const WRAP_CLASS_NAME = "ant-modal-wrap";
export declare class NzModalComponent<T = any, R = any> extends NzModalRef<T, R> implements OnInit, OnChanges, AfterViewInit, OnDestroy, ModalOptions<T> {
    nzConfigService: NzConfigService;
    private overlay;
    private overlayKeyboardDispatcher;
    private i18n;
    private cfr;
    private elementRef;
    private viewContainer;
    private modalControl;
    private focusTrapFactory;
    private cdr;
    private nzModalGlobalConfig;
    private document;
    nzVisible: boolean;
    nzClosable: boolean;
    nzOkLoading: boolean;
    nzOkDisabled: boolean;
    nzCancelDisabled: boolean;
    nzCancelLoading: boolean;
    nzKeyboard: boolean;
    nzNoAnimation: boolean;
    nzMask: boolean;
    nzMaskClosable: boolean;
    nzContent: string | TemplateRef<{}> | Type<T>;
    nzComponentParams: T;
    nzFooter: string | TemplateRef<{}> | Array<ModalButtonOptions<T>> | null;
    nzGetContainer: HTMLElement | OverlayRef | (() => HTMLElement | OverlayRef);
    nzZIndex: number;
    nzWidth: number | string;
    nzWrapClassName: string;
    nzClassName: string;
    nzStyle: object;
    nzTitle: string | TemplateRef<{}>;
    nzCloseIcon: string | TemplateRef<void>;
    nzMaskStyle: object;
    nzBodyStyle: object;
    nzOkText: string | null;
    nzCancelText: string | null;
    nzOkType: string;
    nzIconType: string;
    nzModalType: ModalType;
    readonly nzOnOk: EventEmitter<T> | OnClickCallback<T>;
    readonly nzOnCancel: EventEmitter<T> | OnClickCallback<T>;
    readonly nzAfterOpen: EventEmitter<void>;
    readonly nzAfterClose: EventEmitter<R>;
    readonly nzVisibleChange: EventEmitter<boolean>;
    modalContainer: ElementRef;
    bodyContainer: ViewContainerRef;
    autoFocusButtonOk: ElementRef;
    modalFooter: NzModalFooterDirective;
    readonly afterOpen: Observable<void>;
    readonly afterClose: Observable<R>;
    readonly cancelText: string;
    readonly okText: string;
    readonly hidden: boolean;
    /**
     * @description
     * The calculated highest weight of mask value
     *
     * Weight of different mask input:
     * component default value < global configuration < component input value
     */
    readonly mask: boolean;
    /**
     * @description
     * The calculated highest weight of maskClosable value
     *
     * Weight of different maskClosable input:
     * component default value < global configuration < component input value
     */
    readonly maskClosable: boolean;
    locale: {
        okText?: string;
        cancelText?: string;
    };
    maskAnimationClassMap: object | null;
    modalAnimationClassMap: object | null;
    transformOrigin: string;
    private contentComponentRef;
    private animationState;
    private container;
    private unsubscribe$;
    private previouslyFocusedElement;
    private focusTrap;
    private scrollStrategy;
    private overlayRef;
    private dialogMouseDown;
    private timeoutId;
    [key: string]: any;
    constructor(nzConfigService: NzConfigService, overlay: Overlay, overlayKeyboardDispatcher: OverlayKeyboardDispatcher, i18n: NzI18nService, cfr: ComponentFactoryResolver, elementRef: ElementRef, viewContainer: ViewContainerRef, modalControl: NzModalControlService, focusTrapFactory: FocusTrapFactory, cdr: ChangeDetectorRef, nzModalGlobalConfig: NzModalConfig, document: any);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    setFooterWithTemplate(templateRef: TemplateRef<{}>): void;
    setOverlayRef(overlayRef: OverlayRef): void;
    keydownListener(event: KeyboardEvent): void;
    open(): void;
    close(result?: R): void;
    destroy(result?: R): void;
    triggerOk(): void;
    triggerCancel(): void;
    getInstance(): NzModalComponent;
    getContentComponentRef(): ComponentRef<T>;
    getContentComponent(): T;
    getElement(): HTMLElement;
    onMaskDialogDown(): void;
    onDialogUp(): void;
    onClickMask($event: MouseEvent): void;
    isModalType(type: ModalType): boolean;
    onClickCloseBtn(): void;
    onClickOkCancel(type: 'ok' | 'cancel'): void;
    isNonEmptyString(value: {}): boolean;
    isTemplateRef(value: {}): boolean;
    isComponent(value: {}): boolean;
    isModalButtons(value: string | TemplateRef<{}> | Array<ModalButtonOptions<T>> | null): boolean;
    private handleVisibleStateChange;
    getButtonCallableProp(options: ModalButtonOptions<T>, prop: string): {};
    onButtonClick(button: ModalButtonOptions<T>): void;
    private changeVisibleFromInside;
    private changeAnimationState;
    private animateTo;
    private formatModalButtons;
    /**
     * Create a component dynamically but not attach to any View (this action will be executed when bodyContainer is ready)
     * @param component Component class
     */
    private createDynamicComponent;
    private updateTransformOrigin;
    private savePreviouslyFocusedElement;
    private trapFocus;
    private restoreFocus;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzModalComponent<any, any>>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzModalComponent<any, any>, "nz-modal", ["nzModal"], {
    "nzVisible": "nzVisible";
    "nzClosable": "nzClosable";
    "nzOkLoading": "nzOkLoading";
    "nzOkDisabled": "nzOkDisabled";
    "nzCancelDisabled": "nzCancelDisabled";
    "nzCancelLoading": "nzCancelLoading";
    "nzKeyboard": "nzKeyboard";
    "nzNoAnimation": "nzNoAnimation";
    "nzGetContainer": "nzGetContainer";
    "nzZIndex": "nzZIndex";
    "nzWidth": "nzWidth";
    "nzCloseIcon": "nzCloseIcon";
    "nzOkType": "nzOkType";
    "nzIconType": "nzIconType";
    "nzModalType": "nzModalType";
    "nzOnOk": "nzOnOk";
    "nzOnCancel": "nzOnCancel";
    "nzFooter": "nzFooter";
    "nzMask": "nzMask";
    "nzMaskClosable": "nzMaskClosable";
    "nzContent": "nzContent";
    "nzComponentParams": "nzComponentParams";
    "nzWrapClassName": "nzWrapClassName";
    "nzClassName": "nzClassName";
    "nzStyle": "nzStyle";
    "nzTitle": "nzTitle";
    "nzMaskStyle": "nzMaskStyle";
    "nzBodyStyle": "nzBodyStyle";
    "nzOkText": "nzOkText";
    "nzCancelText": "nzCancelText";
}, {
    "nzOnOk": "nzOnOk";
    "nzOnCancel": "nzOnCancel";
    "nzAfterOpen": "nzAfterOpen";
    "nzAfterClose": "nzAfterClose";
    "nzVisibleChange": "nzVisibleChange";
}, ["modalFooter"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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