/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, NgZone, OnChanges, OnDestroy, OnInit, Renderer2, TemplateRef } from '@angular/core';
import { Observable, Subject } from 'rxjs';
import { NzFormatBeforeDropEvent, NzNoAnimationDirective, NzTreeBaseService, NzTreeNode } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzTreeNodeComponent implements OnInit, OnChanges, OnDestroy {
    nzTreeService: NzTreeBaseService;
    private ngZone;
    private renderer;
    private elRef;
    private cdr;
    noAnimation?: NzNoAnimationDirective | undefined;
    dragElement: ElementRef;
    /**
     * for global property
     */
    nzTreeNode: NzTreeNode;
    nzShowLine: boolean;
    nzShowExpand: boolean;
    nzCheckable: boolean;
    nzAsyncData: boolean;
    nzHideUnMatched: boolean;
    nzNoAnimation: boolean;
    nzSelectMode: boolean;
    nzShowIcon: boolean;
    nzExpandedIcon: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    nzTreeTemplate: TemplateRef<{
        $implicit: NzTreeNode;
    }>;
    nzBeforeDrop: (confirm: NzFormatBeforeDropEvent) => Observable<boolean>;
    nzSearchValue: string;
    nzDraggable: boolean;
    /**
     * @deprecated use `nzExpandAll` instead.
     */
    nzDefaultExpandAll: boolean;
    nzExpandAll: boolean;
    prefixCls: string;
    nzNodeClass: {};
    nzNodeSwitcherClass: {};
    nzNodeContentClass: {};
    nzNodeCheckboxClass: {};
    nzNodeContentIconClass: {};
    nzNodeContentLoadingClass: {};
    /**
     * drag var
     */
    destroy$: Subject<unknown>;
    dragPos: number;
    dragPosClass: {
        [key: string]: string;
    };
    /**
     * default set
     */
    _nzDraggable: boolean;
    _nzExpandAll: boolean;
    readonly nzIcon: string;
    readonly canDraggable: boolean | null;
    readonly isShowLineIcon: boolean;
    readonly isShowSwitchIcon: boolean;
    readonly isSwitcherOpen: boolean;
    readonly isSwitcherClose: boolean;
    readonly displayStyle: string;
    /**
     * reset node class
     */
    setClassMap(): void;
    onMousedown(event: MouseEvent): void;
    /**
     * click node to select, 200ms to dbl click
     */
    nzClick(event: MouseEvent): void;
    nzDblClick(event: MouseEvent): void;
    /**
     * @param event
     */
    nzContextMenu(event: MouseEvent): void;
    /**
     * collapse node
     * @param event
     */
    _clickExpand(event: MouseEvent): void;
    private setDisplayForChildNodes;
    private setDisplayForParentNodes;
    /**
     * check node
     * @param event
     */
    _clickCheckBox(event: MouseEvent): void;
    /**
     * drag event
     * @param e
     */
    clearDragClass(): void;
    handleDragStart(e: DragEvent): void;
    handleDragEnter(e: DragEvent): void;
    handleDragOver(e: DragEvent): void;
    handleDragLeave(e: DragEvent): void;
    handleDragDrop(e: DragEvent): void;
    handleDragEnd(e: DragEvent): void;
    /**
     * Listening to dragging events.
     */
    handDragEvent(): void;
    isTemplateRef(value: {}): boolean;
    markForCheck(): void;
    constructor(nzTreeService: NzTreeBaseService, ngZone: NgZone, renderer: Renderer2, elRef: ElementRef, cdr: ChangeDetectorRef, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnInit(): void;
    ngOnChanges(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTreeNodeComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTreeNodeComponent, "nz-tree-node", ["nzTreeNode"], {
    "nzHideUnMatched": "nzHideUnMatched";
    "nzNoAnimation": "nzNoAnimation";
    "nzSelectMode": "nzSelectMode";
    "nzShowIcon": "nzShowIcon";
    "nzSearchValue": "nzSearchValue";
    "nzDraggable": "nzDraggable";
    "nzDefaultExpandAll": "nzDefaultExpandAll";
    "nzExpandAll": "nzExpandAll";
    "nzTreeNode": "nzTreeNode";
    "nzShowLine": "nzShowLine";
    "nzShowExpand": "nzShowExpand";
    "nzCheckable": "nzCheckable";
    "nzAsyncData": "nzAsyncData";
    "nzExpandedIcon": "nzExpandedIcon";
    "nzTreeTemplate": "nzTreeTemplate";
    "nzBeforeDrop": "nzBeforeDrop";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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