/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { AfterContentChecked, ElementRef, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges } from '@angular/core';
import { IconDirective, ThemeType } from '@ant-design/icons-angular';
import { NzIconService } from './nz-icon.service';
/**
 * This directive extends IconDirective to provide:
 *
 * - IconFont support
 * - spinning
 * - old API compatibility
 *
 * @break-changes
 *
 * - old API compatibility, icon class names would not be supported.
 * - properties that not started with `nz`.
 */
import * as ɵngcc0 from '@angular/core';
export declare class NzIconDirective extends IconDirective implements OnInit, OnChanges, OnDestroy, AfterContentChecked {
    iconService: NzIconService;
    elementRef: ElementRef;
    renderer: Renderer2;
    private platform;
    nzSpin: boolean;
    nzRotate: number;
    nzType: string;
    nzTheme: ThemeType;
    nzTwotoneColor: string;
    nzIconfont: string;
    /** @deprecated 8.0.0 avoid exposing low layer API. */
    spin: boolean;
    /** @deprecated 8.0.0 avoid exposing low layer API. */
    iconfont: string;
    type: string;
    private classNameObserver;
    private el;
    private destroy$;
    private _type;
    /**
     * Replacement of `changeIcon` for more modifications.
     * @param oldAPI
     */
    private changeIcon2;
    private classChangeHandler;
    private handleSpin;
    private handleRotate;
    private setClassName;
    private setSVGData;
    constructor(iconService: NzIconService, elementRef: ElementRef, renderer: Renderer2, platform: Platform);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    /**
     * If custom content is provided, try to normalize SVG elements.
     */
    ngAfterContentChecked(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzIconDirective>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<NzIconDirective, "i.anticon, [nz-icon]", ["nzIcon"], {
    "nzRotate": "nzRotate";
    "spin": "spin";
    "nzSpin": "nzSpin";
    "nzType": "nzType";
    "type": "type";
    "nzTheme": "nzTheme";
    "nzTwotoneColor": "nzTwotoneColor";
    "nzIconfont": "nzIconfont";
    "iconfont": "iconfont";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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