/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, OnDestroy, OnInit, Renderer2, TemplateRef } from '@angular/core';
import { NzNoAnimationDirective } from 'ng-zorro-antd/core';
import { NzOptionComponent } from './nz-option.component';
import { NzSelectService } from './nz-select.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzSelectTopControlComponent implements OnInit, OnDestroy {
    private renderer;
    nzSelectService: NzSelectService;
    private cdr;
    noAnimation?: NzNoAnimationDirective | undefined;
    inputValue: string;
    isComposing: boolean;
    private destroy$;
    inputElement: ElementRef;
    mirrorElement: ElementRef;
    nzShowSearch: boolean;
    nzPlaceHolder: string;
    nzOpen: boolean;
    nzMaxTagCount: number;
    nzAllowClear: boolean;
    nzShowArrow: boolean;
    nzLoading: boolean;
    nzCustomTemplate: TemplateRef<{
        $implicit: NzOptionComponent;
    }>;
    nzSuffixIcon: TemplateRef<void>;
    nzClearIcon: TemplateRef<void>;
    nzRemoveIcon: TemplateRef<void>;
    nzMaxTagPlaceholder: TemplateRef<{
        $implicit: any[];
    }>;
    nzTokenSeparators: string[];
    onClearSelection(e: MouseEvent): void;
    setInputValue(value: string): void;
    readonly mirrorDOM: HTMLElement;
    readonly inputDOM: HTMLInputElement;
    readonly placeHolderDisplay: string;
    readonly selectedValueStyle: {
        [key: string]: string;
    };
    trackValue(_index: number, option: NzOptionComponent): any;
    updateWidth(): void;
    removeSelectedValue(option: NzOptionComponent, e: MouseEvent): void;
    animationEnd(): void;
    constructor(renderer: Renderer2, nzSelectService: NzSelectService, cdr: ChangeDetectorRef, noAnimation?: NzNoAnimationDirective | undefined);
    ngOnInit(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSelectTopControlComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSelectTopControlComponent, "[nz-select-top-control]", ["nzSelectTopControl"], {
    "nzShowSearch": "nzShowSearch";
    "nzOpen": "nzOpen";
    "nzAllowClear": "nzAllowClear";
    "nzShowArrow": "nzShowArrow";
    "nzLoading": "nzLoading";
    "nzTokenSeparators": "nzTokenSeparators";
    "nzPlaceHolder": "nzPlaceHolder";
    "nzMaxTagCount": "nzMaxTagCount";
    "nzCustomTemplate": "nzCustomTemplate";
    "nzSuffixIcon": "nzSuffixIcon";
    "nzClearIcon": "nzClearIcon";
    "nzRemoveIcon": "nzRemoveIcon";
    "nzMaxTagPlaceholder": "nzMaxTagPlaceholder";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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