(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/common'), require('@angular/core'), require('@ant-design/colors'), require('@angular/common/http'), require('@angular/platform-browser'), require('rxjs'), require('rxjs/operators')) :
    typeof define === 'function' && define.amd ? define('@ant-design/icons-angular', ['exports', '@angular/common', '@angular/core', '@ant-design/colors', '@angular/common/http', '@angular/platform-browser', 'rxjs', 'rxjs/operators'], factory) :
    (global = global || self, factory((global['ant-design'] = global['ant-design'] || {}, global['ant-design']['icons-angular'] = {}), global.ng.common, global.ng.core, global.colors, global.ng.common.http, global.ng.platformBrowser, global.rxjs, global.rxjs.operators));
}(this, function (exports, common, core, colors, http, platformBrowser, rxjs, operators) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __rest(s, e) {
        var t = {};
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }

    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }

    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); }
    }

    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
    }

    function __awaiter(thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }

    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f) throw new TypeError("Generator is already executing.");
            while (_) try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                if (y = 0, t) op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0: case 1: t = op; break;
                    case 4: _.label++; return { value: op[1], done: false };
                    case 5: _.label++; y = op[1]; op = [0]; continue;
                    case 7: op = _.ops.pop(); _.trys.pop(); continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                        if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                        if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                        if (t[2]) _.ops.pop();
                        _.trys.pop(); continue;
                }
                op = body.call(thisArg, _);
            } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
            if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
        }
    }

    function __exportStar(m, exports) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }

    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m) return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }

    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    }

    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    };

    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }

    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
    }

    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }

    function __asyncValues(o) {
        if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
    }

    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
        return cooked;
    };

    function __importStar(mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
        result.default = mod;
        return result;
    }

    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var ANT_ICON_ANGULAR_CONSOLE_PREFIX = '[@ant-design/icons-angular]:';
    /**
     * @param {?} message
     * @return {?}
     */
    function error(message) {
        console.error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + " " + message + ".");
    }
    /**
     * @param {?} message
     * @return {?}
     */
    function warn(message) {
        if (core.isDevMode()) {
            console.warn(ANT_ICON_ANGULAR_CONSOLE_PREFIX + " " + message + ".");
        }
    }
    /**
     * @param {?} primaryColor
     * @return {?}
     */
    function getSecondaryColor(primaryColor) {
        return colors.generate(primaryColor)[0];
    }
    /**
     * @param {?} name
     * @param {?} theme
     * @return {?}
     */
    function withSuffix(name, theme) {
        switch (theme) {
            case 'fill': return name + "-fill";
            case 'outline': return name + "-o";
            case 'twotone': return name + "-twotone";
            case undefined: return name;
            default: throw new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "Theme \"" + theme + "\" is not a recognized theme!");
        }
    }
    /**
     * @param {?} name
     * @param {?} theme
     * @param {?} pri
     * @param {?} sec
     * @return {?}
     */
    function withSuffixAndColor(name, theme, pri, sec) {
        return withSuffix(name, theme) + "-" + pri + "-" + sec;
    }
    /**
     * @param {?} abbr
     * @return {?}
     */
    function mapAbbrToTheme(abbr) {
        return abbr === 'o' ? 'outline' : (/** @type {?} */ (abbr));
    }
    /**
     * @param {?} name
     * @return {?}
     */
    function alreadyHasAThemeSuffix(name) {
        return name.endsWith('-fill') || name.endsWith('-o') || name.endsWith('-twotone');
    }
    /**
     * @param {?} target
     * @return {?}
     */
    function isIconDefinition(target) {
        return (typeof target === 'object' &&
            typeof target.name === 'string' &&
            (typeof target.theme === 'string' || target.theme === undefined) &&
            typeof target.icon === 'string');
    }
    /**
     * Get an `IconDefinition` object from abbreviation type, like `account-book-fill`.
     * @param {?} str
     * @return {?}
     */
    function getIconDefinitionFromAbbr(str) {
        /** @type {?} */
        var arr = str.split('-');
        /** @type {?} */
        var theme = mapAbbrToTheme(arr.splice(arr.length - 1, 1)[0]);
        /** @type {?} */
        var name = arr.join('-');
        return (/** @type {?} */ ({
            name: name,
            theme: theme,
            icon: ''
        }));
    }
    /**
     * @param {?} svg
     * @return {?}
     */
    function cloneSVG(svg) {
        return (/** @type {?} */ (svg.cloneNode(true)));
    }
    /**
     * Parse inline SVG string and replace colors with placeholders. For twotone icons only.
     * @param {?} raw
     * @return {?}
     */
    function replaceFillColor(raw) {
        return raw
            .replace(/['"]#333['"]/g, '"primaryColor"')
            .replace(/['"]#E6E6E6['"]/g, '"secondaryColor"')
            .replace(/['"]#D9D9D9['"]/g, '"secondaryColor"')
            .replace(/['"]#D8D8D8['"]/g, '"secondaryColor"');
    }
    /**
     * Split a name with namespace in it into a tuple like [ name, namespace ].
     * @param {?} type
     * @return {?}
     */
    function getNameAndNamespace(type) {
        /** @type {?} */
        var split = type.split(':');
        switch (split.length) {
            case 1: return [type, ''];
            case 2: return [split[1], split[0]];
            default: throw new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "The icon type " + type + " is not valid!");
        }
    }
    /**
     * @param {?} type
     * @return {?}
     */
    function hasNamespace(type) {
        return getNameAndNamespace(type)[1] !== '';
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * @return {?}
     */
    function NameSpaceIsNotSpecifyError() {
        return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "Type should have a namespace. Try \"namespace:" + name + "\".");
    }
    /**
     * @param {?} icon
     * @return {?}
     */
    function IconNotFoundError(icon) {
        return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "the icon " + icon + " does not exist or is not registered.");
    }
    /**
     * @return {?}
     */
    function HttpModuleNotImport() {
        error("you need to import \"HttpClientModule\" to use dynamic importing.");
        return null;
    }
    /**
     * @param {?} url
     * @return {?}
     */
    function UrlNotSafeError(url) {
        return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "The url \"" + url + "\" is unsafe.");
    }
    /**
     * @return {?}
     */
    function SVGTagNotFoundError() {
        return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "<svg> tag not found.");
    }
    /**
     * @return {?}
     */
    function DynamicLoadingTimeoutError() {
        return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "Importing timeout error.");
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /** @type {?} */
    var JSONP_HANDLER_NAME = '__ant_icon_load';
    var IconService = /** @class */ (function () {
        function IconService(_rendererFactory, _handler, _document, sanitizer) {
            this._rendererFactory = _rendererFactory;
            this._handler = _handler;
            this._document = _document;
            this.sanitizer = sanitizer;
            this.defaultTheme = 'outline';
            /**
             * All icon definitions would be registered here.
             */
            this._svgDefinitions = new Map();
            /**
             * Cache all rendered icons. Icons are identified by name, theme,
             * and for twotone icons, primary color and secondary color.
             */
            this._svgRenderedDefinitions = new Map();
            this._inProgressFetches = new Map();
            /**
             * Url prefix for fetching inline SVG by dynamic importing.
             */
            this._assetsUrlRoot = '';
            this._twoToneColorPalette = {
                primaryColor: '#333333',
                secondaryColor: '#E6E6E6'
            };
            /**
             * A flag indicates whether jsonp loading is enabled.
             */
            this._enableJsonpLoading = false;
            this._jsonpIconLoad$ = new rxjs.Subject();
            this._renderer = this._rendererFactory.createRenderer(null, null);
            if (this._handler) {
                this._http = new http.HttpClient(this._handler);
            }
        }
        Object.defineProperty(IconService.prototype, "twoToneColor", {
            get: /**
             * @return {?}
             */
            function () {
                // Make a copy to avoid unexpected changes.
                return (/** @type {?} */ (__assign({}, this._twoToneColorPalette)));
            },
            set: /**
             * @param {?} __0
             * @return {?}
             */
            function (_a) {
                var primaryColor = _a.primaryColor, secondaryColor = _a.secondaryColor;
                this._twoToneColorPalette.primaryColor = primaryColor;
                this._twoToneColorPalette.secondaryColor =
                    secondaryColor || getSecondaryColor(primaryColor);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Call this method to switch to jsonp like loading.
         */
        /**
         * Call this method to switch to jsonp like loading.
         * @return {?}
         */
        IconService.prototype.useJsonpLoading = /**
         * Call this method to switch to jsonp like loading.
         * @return {?}
         */
        function () {
            var _this = this;
            if (!this._enableJsonpLoading) {
                this._enableJsonpLoading = true;
                window[JSONP_HANDLER_NAME] = (/**
                 * @param {?} icon
                 * @return {?}
                 */
                function (icon) {
                    _this._jsonpIconLoad$.next(icon);
                });
            }
            else {
                warn('You are already using jsonp loading.');
            }
        };
        /**
         * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
         * @param prefix
         */
        /**
         * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
         * @param {?} prefix
         * @return {?}
         */
        IconService.prototype.changeAssetsSource = /**
         * Change the prefix of the inline svg resources, so they could be deployed elsewhere, like CDN.
         * @param {?} prefix
         * @return {?}
         */
        function (prefix) {
            this._assetsUrlRoot = prefix.endsWith('/') ? prefix : prefix + '/';
        };
        /**
         * Add icons provided by ant design.
         * @param icons
         */
        /**
         * Add icons provided by ant design.
         * @param {...?} icons
         * @return {?}
         */
        IconService.prototype.addIcon = /**
         * Add icons provided by ant design.
         * @param {...?} icons
         * @return {?}
         */
        function () {
            var _this = this;
            var icons = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                icons[_i] = arguments[_i];
            }
            icons.forEach((/**
             * @param {?} icon
             * @return {?}
             */
            function (icon) {
                _this._svgDefinitions.set(withSuffix(icon.name, icon.theme), icon);
            }));
        };
        /**
         * Register an icon. Namespace is required.
         * @param type
         * @param literal
         */
        /**
         * Register an icon. Namespace is required.
         * @param {?} type
         * @param {?} literal
         * @return {?}
         */
        IconService.prototype.addIconLiteral = /**
         * Register an icon. Namespace is required.
         * @param {?} type
         * @param {?} literal
         * @return {?}
         */
        function (type, literal) {
            var _a = __read(getNameAndNamespace(type), 2), _ = _a[0], namespace = _a[1];
            if (!namespace) {
                throw NameSpaceIsNotSpecifyError();
            }
            this.addIcon({ name: type, icon: literal });
        };
        /**
         * Remove all cache.
         */
        /**
         * Remove all cache.
         * @return {?}
         */
        IconService.prototype.clear = /**
         * Remove all cache.
         * @return {?}
         */
        function () {
            this._svgDefinitions.clear();
            this._svgRenderedDefinitions.clear();
        };
        /**
         * Get a rendered `SVGElement`.
         * @param icon
         * @param twoToneColor
         */
        /**
         * Get a rendered `SVGElement`.
         * @param {?} icon
         * @param {?=} twoToneColor
         * @return {?}
         */
        IconService.prototype.getRenderedContent = /**
         * Get a rendered `SVGElement`.
         * @param {?} icon
         * @param {?=} twoToneColor
         * @return {?}
         */
        function (icon, twoToneColor) {
            var _this = this;
            // If `icon` is a `IconDefinition`, go to the next step. If not, try to fetch it from cache.
            /** @type {?} */
            var definitionOrNull = isIconDefinition(icon)
                ? ((/** @type {?} */ (icon)))
                : this._svgDefinitions.get(icon) || null;
            // If `icon` is a `IconDefinition` of successfully fetch, wrap it in an `Observable`.
            // Otherwise try to fetch it from remote.
            /** @type {?} */
            var $iconDefinition = definitionOrNull
                ? rxjs.of(definitionOrNull)
                : this._loadIconDynamically((/** @type {?} */ (icon)));
            // If finally get an `IconDefinition`, render and return it. Otherwise throw an error.
            return $iconDefinition.pipe(operators.map((/**
             * @param {?} i
             * @return {?}
             */
            function (i) {
                if (!i) {
                    throw IconNotFoundError((/** @type {?} */ (icon)));
                }
                return _this._loadSVGFromCacheOrCreateNew(i, twoToneColor);
            })));
        };
        /**
         * @return {?}
         */
        IconService.prototype.getCachedIcons = /**
         * @return {?}
         */
        function () {
            return this._svgDefinitions;
        };
        /**
         * Get raw svg and assemble a `IconDefinition` object.
         * @param type
         */
        /**
         * Get raw svg and assemble a `IconDefinition` object.
         * @protected
         * @param {?} type
         * @return {?}
         */
        IconService.prototype._loadIconDynamically = /**
         * Get raw svg and assemble a `IconDefinition` object.
         * @protected
         * @param {?} type
         * @return {?}
         */
        function (type) {
            var _this = this;
            // If developer doesn't provide HTTP module nor enable jsonp loading, just throw an error.
            if (!this._http && !this._enableJsonpLoading) {
                return rxjs.of(HttpModuleNotImport());
            }
            // If multi directive ask for the same icon at the same time,
            // request should only be fired once.
            /** @type {?} */
            var inProgress = this._inProgressFetches.get(type);
            if (!inProgress) {
                var _a = __read(getNameAndNamespace(type), 2), name_1 = _a[0], namespace = _a[1];
                // If the string has a namespace within, create a simple `IconDefinition`.
                /** @type {?} */
                var icon_1 = namespace
                    ? { name: type, icon: '' }
                    : getIconDefinitionFromAbbr(name_1);
                /** @type {?} */
                var suffix = this._enableJsonpLoading ? '.js' : '.svg';
                /** @type {?} */
                var url = (namespace
                    ? this._assetsUrlRoot + "assets/" + namespace + "/" + name_1
                    : this._assetsUrlRoot + "assets/" + icon_1.theme + "/" + icon_1.name) + suffix;
                /** @type {?} */
                var safeUrl = this.sanitizer.sanitize(core.SecurityContext.URL, url);
                if (!safeUrl) {
                    throw UrlNotSafeError(url);
                }
                /** @type {?} */
                var source = !this._enableJsonpLoading
                    ? this._http
                        .get(safeUrl, { responseType: 'text' })
                        .pipe(operators.map((/**
                     * @param {?} literal
                     * @return {?}
                     */
                    function (literal) { return (__assign({}, icon_1, { icon: literal })); })))
                    : this._loadIconDynamicallyWithJsonp(icon_1, safeUrl);
                inProgress = source.pipe(operators.tap((/**
                 * @param {?} definition
                 * @return {?}
                 */
                function (definition) { return _this.addIcon(definition); })), operators.finalize((/**
                 * @return {?}
                 */
                function () { return _this._inProgressFetches.delete(type); })), operators.catchError((/**
                 * @return {?}
                 */
                function () { return rxjs.of(null); })), operators.share());
                this._inProgressFetches.set(type, inProgress);
            }
            return inProgress;
        };
        /**
         * @protected
         * @param {?} icon
         * @param {?} url
         * @return {?}
         */
        IconService.prototype._loadIconDynamicallyWithJsonp = /**
         * @protected
         * @param {?} icon
         * @param {?} url
         * @return {?}
         */
        function (icon, url) {
            var _this = this;
            return new rxjs.Observable((/**
             * @param {?} subscriber
             * @return {?}
             */
            function (subscriber) {
                /** @type {?} */
                var loader = _this._document.createElement('script');
                /** @type {?} */
                var timer = setTimeout((/**
                 * @return {?}
                 */
                function () {
                    clean();
                    subscriber.error(DynamicLoadingTimeoutError());
                }), 6000);
                loader.src = url;
                /**
                 * @return {?}
                 */
                function clean() {
                    loader.parentNode.removeChild(loader);
                    clearTimeout(timer);
                }
                _this._document.body.appendChild(loader);
                _this._jsonpIconLoad$
                    .pipe(operators.filter((/**
                 * @param {?} i
                 * @return {?}
                 */
                function (i) { return i.name === icon.name && i.theme === icon.theme; })), operators.take(1))
                    .subscribe((/**
                 * @param {?} i
                 * @return {?}
                 */
                function (i) {
                    subscriber.next(i);
                    clean();
                }));
            }));
        };
        /**
         * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
         * @param icon
         * @param twoToneColor
         */
        /**
         * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
         * @protected
         * @param {?} icon
         * @param {?=} twoToneColor
         * @return {?}
         */
        IconService.prototype._loadSVGFromCacheOrCreateNew = /**
         * Render a new `SVGElement` for a given `IconDefinition`, or make a copy from cache.
         * @protected
         * @param {?} icon
         * @param {?=} twoToneColor
         * @return {?}
         */
        function (icon, twoToneColor) {
            /** @type {?} */
            var svg;
            /** @type {?} */
            var pri = twoToneColor || this._twoToneColorPalette.primaryColor;
            /** @type {?} */
            var sec = getSecondaryColor(pri) || this._twoToneColorPalette.secondaryColor;
            /** @type {?} */
            var key = icon.theme === 'twotone'
                ? withSuffixAndColor(icon.name, icon.theme, pri, sec)
                : icon.theme === undefined
                    ? icon.name
                    : withSuffix(icon.name, icon.theme);
            // Try to make a copy from cache.
            /** @type {?} */
            var cached = this._svgRenderedDefinitions.get(key);
            if (cached) {
                svg = cached.icon;
            }
            else {
                svg = this._setSVGAttribute(this._colorizeSVGIcon(
                // Icons provided by ant design should be refined to remove preset colors.
                this._createSVGElementFromString(hasNamespace(icon.name) ? icon.icon : replaceFillColor(icon.icon)), icon.theme === 'twotone', pri, sec));
                // Cache it.
                this._svgRenderedDefinitions.set(key, (/** @type {?} */ (__assign({}, icon, { icon: svg }))));
            }
            return cloneSVG(svg);
        };
        /**
         * @protected
         * @param {?} str
         * @return {?}
         */
        IconService.prototype._createSVGElementFromString = /**
         * @protected
         * @param {?} str
         * @return {?}
         */
        function (str) {
            /** @type {?} */
            var div = this._document.createElement('div');
            div.innerHTML = str;
            /** @type {?} */
            var svg = div.querySelector('svg');
            if (!svg) {
                throw SVGTagNotFoundError;
            }
            return svg;
        };
        /**
         * @protected
         * @param {?} svg
         * @return {?}
         */
        IconService.prototype._setSVGAttribute = /**
         * @protected
         * @param {?} svg
         * @return {?}
         */
        function (svg) {
            this._renderer.setAttribute(svg, 'width', '1em');
            this._renderer.setAttribute(svg, 'height', '1em');
            return svg;
        };
        /**
         * @protected
         * @param {?} svg
         * @param {?} twotone
         * @param {?} pri
         * @param {?} sec
         * @return {?}
         */
        IconService.prototype._colorizeSVGIcon = /**
         * @protected
         * @param {?} svg
         * @param {?} twotone
         * @param {?} pri
         * @param {?} sec
         * @return {?}
         */
        function (svg, twotone, pri, sec) {
            if (twotone) {
                /** @type {?} */
                var children = svg.childNodes;
                /** @type {?} */
                var length_1 = children.length;
                for (var i = 0; i < length_1; i++) {
                    /** @type {?} */
                    var child = (/** @type {?} */ (children[i]));
                    if (child.getAttribute('fill') === 'secondaryColor') {
                        this._renderer.setAttribute(child, 'fill', sec);
                    }
                    else {
                        this._renderer.setAttribute(child, 'fill', pri);
                    }
                }
            }
            this._renderer.setAttribute(svg, 'fill', 'currentColor');
            return svg;
        };
        /** @nocollapse */
        IconService.ctorParameters = function () { return [
            { type: core.RendererFactory2 },
            { type: http.HttpBackend, decorators: [{ type: core.Optional }] },
            { type: undefined, decorators: [{ type: core.Optional }, { type: core.Inject, args: [common.DOCUMENT,] }] },
            { type: platformBrowser.DomSanitizer }
        ]; };
        return IconService;
    }());
    if (false) {
        /** @type {?} */
        IconService.prototype.defaultTheme;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._renderer;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._http;
        /**
         * All icon definitions would be registered here.
         * @type {?}
         * @protected
         */
        IconService.prototype._svgDefinitions;
        /**
         * Cache all rendered icons. Icons are identified by name, theme,
         * and for twotone icons, primary color and secondary color.
         * @type {?}
         * @protected
         */
        IconService.prototype._svgRenderedDefinitions;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._inProgressFetches;
        /**
         * Url prefix for fetching inline SVG by dynamic importing.
         * @type {?}
         * @protected
         */
        IconService.prototype._assetsUrlRoot;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._twoToneColorPalette;
        /**
         * A flag indicates whether jsonp loading is enabled.
         * @type {?}
         * @private
         */
        IconService.prototype._enableJsonpLoading;
        /**
         * @type {?}
         * @private
         */
        IconService.prototype._jsonpIconLoad$;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._rendererFactory;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._handler;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype._document;
        /**
         * @type {?}
         * @protected
         */
        IconService.prototype.sanitizer;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var IconDirective = /** @class */ (function () {
        function IconDirective(_iconService, _elementRef, _renderer) {
            this._iconService = _iconService;
            this._elementRef = _elementRef;
            this._renderer = _renderer;
        }
        /**
         * @param {?} changes
         * @return {?}
         */
        IconDirective.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
        function (changes) {
            if (changes.type || changes.theme || changes.twoToneColor) {
                this._changeIcon();
            }
        };
        /**
         * Render a new icon in the current element. Remove the icon when `type` is falsy.
         */
        /**
         * Render a new icon in the current element. Remove the icon when `type` is falsy.
         * @protected
         * @return {?}
         */
        IconDirective.prototype._changeIcon = /**
         * Render a new icon in the current element. Remove the icon when `type` is falsy.
         * @protected
         * @return {?}
         */
        function () {
            var _this = this;
            return new Promise((/**
             * @param {?} resolve
             * @return {?}
             */
            function (resolve) {
                if (!_this.type) {
                    _this._clearSVGElement();
                    resolve(null);
                }
                else {
                    _this._iconService.getRenderedContent(_this._parseIconType(_this.type, _this.theme), _this.twoToneColor).subscribe((/**
                     * @param {?} svg
                     * @return {?}
                     */
                    function (svg) {
                        _this._setSVGElement(svg);
                        resolve(svg);
                    }));
                }
            }));
        };
        /**
         * Parse a icon to the standard form, an `IconDefinition` or a string like 'account-book-fill` (with a theme suffixed).
         * If namespace is specified, ignore theme because it meaningless for users' icons.
         * @param type
         * @param theme
         */
        /**
         * Parse a icon to the standard form, an `IconDefinition` or a string like 'account-book-fill` (with a theme suffixed).
         * If namespace is specified, ignore theme because it meaningless for users' icons.
         * @protected
         * @param {?} type
         * @param {?} theme
         * @return {?}
         */
        IconDirective.prototype._parseIconType = /**
         * Parse a icon to the standard form, an `IconDefinition` or a string like 'account-book-fill` (with a theme suffixed).
         * If namespace is specified, ignore theme because it meaningless for users' icons.
         * @protected
         * @param {?} type
         * @param {?} theme
         * @return {?}
         */
        function (type, theme) {
            if (isIconDefinition(type)) {
                return type;
            }
            else {
                var _a = __read(getNameAndNamespace(type), 2), name_1 = _a[0], namespace = _a[1];
                if (namespace) {
                    return type;
                }
                if (alreadyHasAThemeSuffix(name_1)) {
                    if (!!theme) {
                        warn("'type' " + name_1 + " already gets a theme inside so 'theme' " + theme + " would be ignored");
                    }
                    return name_1;
                }
                else {
                    return withSuffix(name_1, theme || this._iconService.defaultTheme);
                }
            }
        };
        /**
         * @protected
         * @param {?} svg
         * @return {?}
         */
        IconDirective.prototype._setSVGElement = /**
         * @protected
         * @param {?} svg
         * @return {?}
         */
        function (svg) {
            this._clearSVGElement();
            this._renderer.appendChild(this._elementRef.nativeElement, svg);
        };
        /**
         * @protected
         * @return {?}
         */
        IconDirective.prototype._clearSVGElement = /**
         * @protected
         * @return {?}
         */
        function () {
            /** @type {?} */
            var el = this._elementRef.nativeElement;
            /** @type {?} */
            var children = el.childNodes;
            /** @type {?} */
            var length = children.length;
            for (var i = length - 1; i >= 0; i--) {
                /** @type {?} */
                var child = (/** @type {?} */ (children[i]));
                if (child.tagName.toLowerCase() === 'svg') {
                    this._renderer.removeChild(el, child);
                }
            }
        };
        IconDirective.decorators = [
            { type: core.Directive, args: [{
                        selector: '[antIcon]'
                    },] }
        ];
        /** @nocollapse */
        IconDirective.ctorParameters = function () { return [
            { type: IconService },
            { type: core.ElementRef },
            { type: core.Renderer2 }
        ]; };
        IconDirective.propDecorators = {
            type: [{ type: core.Input }],
            theme: [{ type: core.Input }],
            twoToneColor: [{ type: core.Input }]
        };
        return IconDirective;
    }());
    if (false) {
        /** @type {?} */
        IconDirective.prototype.type;
        /** @type {?} */
        IconDirective.prototype.theme;
        /** @type {?} */
        IconDirective.prototype.twoToneColor;
        /**
         * @type {?}
         * @protected
         */
        IconDirective.prototype._iconService;
        /**
         * @type {?}
         * @protected
         */
        IconDirective.prototype._elementRef;
        /**
         * @type {?}
         * @protected
         */
        IconDirective.prototype._renderer;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    var IconModule = /** @class */ (function () {
        function IconModule() {
        }
        IconModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [common.CommonModule],
                        exports: [IconDirective],
                        declarations: [IconDirective],
                        providers: [IconService]
                    },] }
        ];
        return IconModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    /**
     * @record
     */
    function IconDefinition() { }
    if (false) {
        /** @type {?} */
        IconDefinition.prototype.name;
        /** @type {?|undefined} */
        IconDefinition.prototype.theme;
        /** @type {?} */
        IconDefinition.prototype.icon;
    }
    /**
     * @record
     */
    function Manifest() { }
    if (false) {
        /** @type {?} */
        Manifest.prototype.fill;
        /** @type {?} */
        Manifest.prototype.outline;
        /** @type {?} */
        Manifest.prototype.twotone;
    }
    /**
     * @record
     */
    function CachedIconDefinition() { }
    if (false) {
        /** @type {?} */
        CachedIconDefinition.prototype.name;
        /** @type {?} */
        CachedIconDefinition.prototype.theme;
        /** @type {?} */
        CachedIconDefinition.prototype.icon;
    }
    /**
     * @record
     */
    function TwoToneColorPaletteSetter() { }
    if (false) {
        /** @type {?} */
        TwoToneColorPaletteSetter.prototype.primaryColor;
        /** @type {?|undefined} */
        TwoToneColorPaletteSetter.prototype.secondaryColor;
    }
    /**
     * @record
     */
    function TwoToneColorPalette() { }
    if (false) {
        /** @type {?} */
        TwoToneColorPalette.prototype.secondaryColor;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
     */
    // This icon file is generated by build/generate.ts
    // tslint:disable
    /** @type {?} */
    var manifest = {
        fill: [
            'account-book',
            'alert',
            'alipay-circle',
            'alipay-square',
            'aliwangwang',
            'amazon-circle',
            'amazon-square',
            'android',
            'api',
            'apple',
            'appstore',
            'audio',
            'backward',
            'behance-circle',
            'bank',
            'behance-square',
            'bell',
            'book',
            'box-plot',
            'bug',
            'build',
            'bulb',
            'calculator',
            'calendar',
            'car',
            'camera',
            'caret-left',
            'caret-right',
            'caret-down',
            'caret-up',
            'carry-out',
            'check-circle',
            'chrome',
            'check-square',
            'ci-circle',
            'clock-circle',
            'close-square',
            'cloud',
            'code-sandbox-circle',
            'code-sandbox-square',
            'code',
            'codepen-circle',
            'compass',
            'codepen-square',
            'container',
            'close-circle',
            'control',
            'copy',
            'credit-card',
            'contacts',
            'customer-service',
            'dashboard',
            'database',
            'delete',
            'diff',
            'dingtalk-circle',
            'dingtalk-square',
            'dislike',
            'dollar-circle',
            'down-circle',
            'down-square',
            'dribbble-circle',
            'dribbble-square',
            'dropbox-circle',
            'dropbox-square',
            'edit',
            'environment',
            'exclamation-circle',
            'euro-circle',
            'experiment',
            'eye-invisible',
            'eye',
            'facebook',
            'fast-backward',
            'fast-forward',
            'copyright-circle',
            'file-add',
            'crown',
            'file-excel',
            'file-image',
            'file-pdf',
            'file-exclamation',
            'file-ppt',
            'file-text',
            'file-word',
            'file-zip',
            'file',
            'file-markdown',
            'fire',
            'filter',
            'flag',
            'folder-add',
            'folder-open',
            'folder',
            'forward',
            'frown',
            'fund',
            'funnel-plot',
            'gift',
            'github',
            'gitlab',
            'golden',
            'google-circle',
            'google-plus-circle',
            'hdd',
            'google-square',
            'google-plus-square',
            'heart',
            'highlight',
            'home',
            'hourglass',
            'html5',
            'ie-circle',
            'idcard',
            'ie-square',
            'info-circle',
            'instagram',
            'insurance',
            'interaction',
            'layout',
            'left-circle',
            'interation',
            'left-square',
            'like',
            'linkedin',
            'mail',
            'lock',
            'medicine-box',
            'medium-circle',
            'medium-square',
            'meh',
            'message',
            'minus-circle',
            'minus-square',
            'mobile',
            'money-collect',
            'notification',
            'pause-circle',
            'pay-circle',
            'phone',
            'picture',
            'pie-chart',
            'play-circle',
            'play-square',
            'plus-square',
            'pound-circle',
            'printer',
            'profile',
            'property-safety',
            'project',
            'qq-circle',
            'pushpin',
            'qq-square',
            'question-circle',
            'reconciliation',
            'read',
            'red-envelope',
            'reddit-circle',
            'reddit-square',
            'rest',
            'right-circle',
            'right-square',
            'rocket',
            'safety-certificate',
            'save',
            'security-scan',
            'schedule',
            'setting',
            'shop',
            'shopping',
            'sketch-circle',
            'sketch-square',
            'skin',
            'skype',
            'slack-circle',
            'slack-square',
            'sliders',
            'smile',
            'snippets',
            'sound',
            'star',
            'step-backward',
            'step-forward',
            'stop',
            'switcher',
            'tag',
            'file-unknown',
            'tags',
            'tablet',
            'taobao-square',
            'taobao-circle',
            'thunderbolt',
            'tool',
            'trademark-circle',
            'trophy',
            'twitter-circle',
            'twitter-square',
            'unlock',
            'up-circle',
            'up-square',
            'usb',
            'video-camera',
            'wallet',
            'warning',
            'wechat',
            'weibo-circle',
            'weibo-square',
            'windows',
            'yahoo',
            'youtube',
            'zhihu-circle',
            'zhihu-square',
            'yuque',
            'plus-circle'
        ],
        outline: [
            'account-book',
            'alert',
            'alipay-circle',
            'aliwangwang',
            'android',
            'api',
            'apple',
            'appstore',
            'audio',
            'backward',
            'bank',
            'behance-square',
            'bell',
            'book',
            'box-plot',
            'bug',
            'build',
            'bulb',
            'calculator',
            'calendar',
            'car',
            'camera',
            'caret-left',
            'caret-right',
            'caret-down',
            'caret-up',
            'carry-out',
            'check-circle',
            'chrome',
            'check-square',
            'clock-circle',
            'close-square',
            'cloud',
            'code',
            'codepen-circle',
            'compass',
            'container',
            'close-circle',
            'control',
            'copy',
            'credit-card',
            'contacts',
            'customer-service',
            'dashboard',
            'database',
            'delete',
            'diff',
            'dislike',
            'down-circle',
            'down-square',
            'dribbble-square',
            'edit',
            'environment',
            'exclamation-circle',
            'experiment',
            'eye-invisible',
            'eye',
            'facebook',
            'fast-backward',
            'fast-forward',
            'file-add',
            'crown',
            'file-excel',
            'file-image',
            'file-pdf',
            'file-exclamation',
            'file-ppt',
            'file-text',
            'file-word',
            'file-zip',
            'file',
            'file-markdown',
            'fire',
            'filter',
            'flag',
            'folder-add',
            'folder-open',
            'folder',
            'forward',
            'frown',
            'fund',
            'funnel-plot',
            'gift',
            'github',
            'gitlab',
            'hdd',
            'heart',
            'highlight',
            'home',
            'hourglass',
            'html5',
            'idcard',
            'info-circle',
            'instagram',
            'insurance',
            'interaction',
            'layout',
            'left-circle',
            'interation',
            'left-square',
            'like',
            'linkedin',
            'mail',
            'lock',
            'medicine-box',
            'meh',
            'message',
            'minus-circle',
            'minus-square',
            'mobile',
            'money-collect',
            'notification',
            'pause-circle',
            'pay-circle',
            'phone',
            'picture',
            'pie-chart',
            'play-circle',
            'play-square',
            'plus-square',
            'printer',
            'profile',
            'property-safety',
            'project',
            'pushpin',
            'question-circle',
            'reconciliation',
            'read',
            'red-envelope',
            'rest',
            'right-circle',
            'right-square',
            'rocket',
            'safety-certificate',
            'save',
            'security-scan',
            'schedule',
            'setting',
            'shop',
            'shopping',
            'skin',
            'skype',
            'slack-square',
            'sliders',
            'smile',
            'snippets',
            'sound',
            'star',
            'step-backward',
            'step-forward',
            'stop',
            'switcher',
            'tag',
            'file-unknown',
            'tags',
            'tablet',
            'taobao-circle',
            'thunderbolt',
            'tool',
            'trophy',
            'unlock',
            'up-circle',
            'up-square',
            'usb',
            'video-camera',
            'wallet',
            'warning',
            'wechat',
            'weibo-circle',
            'weibo-square',
            'windows',
            'yahoo',
            'youtube',
            'yuque',
            'plus-circle',
            'align-center',
            'alibaba',
            'align-left',
            'align-right',
            'alipay',
            'aliyun',
            'amazon',
            'ant-design',
            'ant-cloud',
            'apartment',
            'area-chart',
            'arrow-left',
            'arrow-right',
            'arrow-down',
            'arrows-alt',
            'arrow-up',
            'audit',
            'bar-chart',
            'barcode',
            'bars',
            'bg-colors',
            'behance',
            'block',
            'bold',
            'border-bottom',
            'border-horizontal',
            'border-inner',
            'border-outer',
            'border-left',
            'border-top',
            'border-verticle',
            'border',
            'branches',
            'check',
            'ci',
            'close',
            'cloud-download',
            'cloud-server',
            'cloud-sync',
            'cloud-upload',
            'cluster',
            'code-sandbox',
            'codepen',
            'coffee',
            'colum-height',
            'column-height',
            'copyright',
            'dash',
            'column-width',
            'deployment-unit',
            'dingding',
            'disconnect',
            'dollar',
            'dot-chart',
            'double-left',
            'double-right',
            'border-right',
            'desktop',
            'down',
            'drag',
            'download',
            'dropbox',
            'dribbble',
            'ellipsis',
            'enter',
            'euro',
            'exception',
            'exclamation',
            'export',
            'fall',
            'file-done',
            'file-jpg',
            'file-protect',
            'file-search',
            'file-sync',
            'font-colors',
            'font-size',
            'fork',
            'form',
            'fullscreen-exit',
            'fullscreen',
            'gateway',
            'global',
            'gold',
            'google-plus',
            'google',
            'heat-map',
            'history',
            'ie',
            'import',
            'info',
            'inbox',
            'issues-close',
            'italic',
            'key',
            'laptop',
            'left',
            'line-chart',
            'line',
            'link',
            'loading-3-quarters',
            'loading',
            'login',
            'logout',
            'man',
            'medium-workmark',
            'medium',
            'menu-fold',
            'menu-unfold',
            'menu',
            'minus',
            'monitor',
            'more',
            'number',
            'ordered-list',
            'paper-clip',
            'pause',
            'percentage',
            'pic-center',
            'pic-left',
            'pic-right',
            'line-height',
            'plus',
            'pound',
            'poweroff',
            'pull-request',
            'qq',
            'qrcode',
            'question',
            'radar-chart',
            'radius-bottomleft',
            'radius-bottomright',
            'radius-setting',
            'radius-upleft',
            'radius-upright',
            'reddit',
            'redo',
            'reload',
            'retweet',
            'right',
            'rise',
            'robot',
            'rollback',
            'safety',
            'scan',
            'search',
            'scissor',
            'select',
            'shake',
            'share-alt',
            'shopping-cart',
            'shrink',
            'sketch',
            'slack',
            'small-dash',
            'solution',
            'sort-ascending',
            'sort-descending',
            'stock',
            'strikethrough',
            'swap-left',
            'swap-right',
            'swap',
            'sync',
            'table',
            'taobao',
            'team',
            'to-top',
            'trademark',
            'transaction',
            'twitter',
            'underline',
            'undo',
            'unordered-list',
            'up',
            'upload',
            'user-add',
            'user-delete',
            'user',
            'usergroup-add',
            'vertical-align-middle',
            'usergroup-delete',
            'vertical-align-bottom',
            'vertical-align-top',
            'vertical-left',
            'vertical-right',
            'weibo',
            'wifi',
            'woman',
            'zoom-out',
            'zhihu',
            'zoom-in'
        ],
        twotone: [
            'account-book',
            'alert',
            'api',
            'appstore',
            'audio',
            'bank',
            'bell',
            'book',
            'box-plot',
            'bug',
            'build',
            'bulb',
            'calculator',
            'calendar',
            'car',
            'camera',
            'carry-out',
            'check-circle',
            'check-square',
            'clock-circle',
            'close-square',
            'cloud',
            'code',
            'compass',
            'container',
            'close-circle',
            'control',
            'copy',
            'credit-card',
            'contacts',
            'customer-service',
            'dashboard',
            'database',
            'delete',
            'diff',
            'dislike',
            'down-circle',
            'down-square',
            'edit',
            'environment',
            'exclamation-circle',
            'experiment',
            'eye-invisible',
            'eye',
            'file-add',
            'crown',
            'file-excel',
            'file-image',
            'file-pdf',
            'file-exclamation',
            'file-ppt',
            'file-text',
            'file-word',
            'file-zip',
            'file',
            'file-markdown',
            'fire',
            'filter',
            'flag',
            'folder-add',
            'folder-open',
            'folder',
            'frown',
            'fund',
            'funnel-plot',
            'gift',
            'hdd',
            'heart',
            'highlight',
            'home',
            'hourglass',
            'html5',
            'idcard',
            'info-circle',
            'insurance',
            'interaction',
            'layout',
            'left-circle',
            'interation',
            'left-square',
            'like',
            'mail',
            'lock',
            'medicine-box',
            'meh',
            'message',
            'minus-circle',
            'minus-square',
            'mobile',
            'money-collect',
            'notification',
            'pause-circle',
            'phone',
            'picture',
            'pie-chart',
            'play-circle',
            'play-square',
            'plus-square',
            'pound-circle',
            'printer',
            'profile',
            'property-safety',
            'project',
            'pushpin',
            'question-circle',
            'reconciliation',
            'red-envelope',
            'rest',
            'right-circle',
            'right-square',
            'rocket',
            'safety-certificate',
            'save',
            'security-scan',
            'schedule',
            'setting',
            'shop',
            'shopping',
            'skin',
            'sliders',
            'smile',
            'snippets',
            'sound',
            'star',
            'stop',
            'switcher',
            'tag',
            'file-unknown',
            'tags',
            'tablet',
            'thunderbolt',
            'tool',
            'trademark-circle',
            'trophy',
            'unlock',
            'up-circle',
            'up-square',
            'usb',
            'video-camera',
            'wallet',
            'warning',
            'plus-circle',
            'ci',
            'copyright',
            'dollar',
            'euro',
            'gold',
            'canlendar'
        ]
    };

    exports.ANT_ICON_ANGULAR_CONSOLE_PREFIX = ANT_ICON_ANGULAR_CONSOLE_PREFIX;
    exports.DynamicLoadingTimeoutError = DynamicLoadingTimeoutError;
    exports.HttpModuleNotImport = HttpModuleNotImport;
    exports.IconDirective = IconDirective;
    exports.IconModule = IconModule;
    exports.IconNotFoundError = IconNotFoundError;
    exports.IconService = IconService;
    exports.NameSpaceIsNotSpecifyError = NameSpaceIsNotSpecifyError;
    exports.SVGTagNotFoundError = SVGTagNotFoundError;
    exports.UrlNotSafeError = UrlNotSafeError;
    exports.alreadyHasAThemeSuffix = alreadyHasAThemeSuffix;
    exports.cloneSVG = cloneSVG;
    exports.error = error;
    exports.getIconDefinitionFromAbbr = getIconDefinitionFromAbbr;
    exports.getNameAndNamespace = getNameAndNamespace;
    exports.getSecondaryColor = getSecondaryColor;
    exports.hasNamespace = hasNamespace;
    exports.isIconDefinition = isIconDefinition;
    exports.manifest = manifest;
    exports.mapAbbrToTheme = mapAbbrToTheme;
    exports.replaceFillColor = replaceFillColor;
    exports.warn = warn;
    exports.withSuffix = withSuffix;
    exports.withSuffixAndColor = withSuffixAndColor;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=ant-design-icons-angular.umd.js.map
