/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { ChangeDetectorRef, EventEmitter, OnDestroy, OnInit, TemplateRef } from '@angular/core';
import { NzConfigService, NzScrollService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzBackTopComponent implements OnInit, OnDestroy {
    nzConfigService: NzConfigService;
    private scrollSrv;
    private doc;
    private platform;
    private cd;
    private scroll$;
    private target;
    visible: boolean;
    nzTemplate: TemplateRef<void>;
    nzVisibilityHeight: number;
    nzTarget: string | HTMLElement;
    readonly nzClick: EventEmitter<boolean>;
    constructor(nzConfigService: NzConfigService, scrollSrv: NzScrollService, doc: any, platform: Platform, cd: ChangeDetectorRef);
    ngOnInit(): void;
    clickBackTop(): void;
    private getTarget;
    private handleScroll;
    private removeListen;
    private registerScrollEvent;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzBackTopComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzBackTopComponent, "nz-back-top", ["nzBackTop"], {
    "nzTarget": "nzTarget";
    "nzTemplate": "nzTemplate";
    "nzVisibilityHeight": "nzVisibilityHeight";
}, {
    "nzClick": "nzClick";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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