/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ElementRef, EventEmitter, OnChanges, SimpleChanges, TemplateRef } from '@angular/core';
import { Location } from '@angular/common';
import { NzConfigService } from 'ng-zorro-antd/core';
import { NzPageHeaderBreadcrumbDirective, NzPageHeaderFooterDirective } from './nz-page-header-cells';
import * as ɵngcc0 from '@angular/core';
export declare class NzPageHeaderComponent implements OnChanges {
    private location;
    nzConfigService: NzConfigService;
    isTemplateRefBackIcon: boolean;
    isStringBackIcon: boolean;
    nzBackIcon: string | TemplateRef<void> | null;
    nzTitle: string | TemplateRef<void>;
    nzSubtitle: string | TemplateRef<void>;
    nzGhost: boolean;
    readonly nzBack: EventEmitter<void>;
    nzPageHeaderFooter: ElementRef<NzPageHeaderFooterDirective>;
    nzPageHeaderBreadcrumb: ElementRef<NzPageHeaderBreadcrumbDirective>;
    constructor(location: Location, nzConfigService: NzConfigService);
    ngOnChanges(changes: SimpleChanges): void;
    onBack(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzPageHeaderComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzPageHeaderComponent, "nz-page-header", ["nzPageHeader"], {
    "nzBackIcon": "nzBackIcon";
    "nzTitle": "nzTitle";
    "nzSubtitle": "nzSubtitle";
    "nzGhost": "nzGhost";
}, {
    "nzBack": "nzBack";
}, ["nzPageHeaderFooter", "nzPageHeaderBreadcrumb"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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