/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { HttpClient } from '@angular/common/http';
import { ElementRef, OnChanges, OnDestroy, OnInit } from '@angular/core';
import { Subscription } from 'rxjs';
import { NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { UploadFile, ZipButtonOptions } from './interface';
import * as ɵngcc0 from '@angular/core';
export declare class NzUploadBtnComponent implements OnInit, OnChanges, OnDestroy {
    private http;
    private el;
    private updateHostClassService;
    reqs: {
        [key: string]: Subscription;
    };
    private inited;
    private destroy;
    file: ElementRef;
    classes: {};
    options: ZipButtonOptions;
    onClick(): void;
    onKeyDown(e: KeyboardEvent): void;
    onFileDrop(e: any): void;
    onChange(e: Event): void;
    private traverseFileTree;
    private attrAccept;
    private attachUid;
    uploadFiles(fileList: FileList | File[]): void;
    private upload;
    private post;
    private xhr;
    private clean;
    abort(file?: UploadFile): void;
    private prefixCls;
    private setClassMap;
    constructor(http: HttpClient, el: ElementRef, updateHostClassService: NzUpdateHostClassService);
    ngOnInit(): void;
    ngOnChanges(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzUploadBtnComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzUploadBtnComponent, "[nz-upload-btn]", ["nzUploadBtn"], {
    "classes": "classes";
    "options": "options";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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