/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { MediaMatcher } from '@angular/cdk/layout';
import { Platform } from '@angular/cdk/platform';
import { AfterContentInit, ChangeDetectorRef, OnChanges, OnDestroy, QueryList, SimpleChanges, TemplateRef } from '@angular/core';
import { NzBreakpoint, NzConfigService, NzDomEventService } from 'ng-zorro-antd/core';
import { NzDescriptionsItemRenderProps, NzDescriptionsLayout, NzDescriptionsSize } from './nz-descriptions-definitions';
import { NzDescriptionsItemComponent } from './nz-descriptions-item.component';
import * as ɵngcc0 from '@angular/core';
export declare class NzDescriptionsComponent implements OnChanges, OnDestroy, AfterContentInit {
    nzConfigService: NzConfigService;
    private cdr;
    private mediaMatcher;
    private platform;
    private nzDomEventService;
    items: QueryList<NzDescriptionsItemComponent>;
    nzBordered: boolean;
    nzLayout: NzDescriptionsLayout;
    nzColumn: number | {
        [key in NzBreakpoint]: number;
    };
    nzSize: NzDescriptionsSize;
    nzTitle: string | TemplateRef<void>;
    nzColon: boolean;
    itemMatrix: NzDescriptionsItemRenderProps[][];
    realColumn: number;
    private destroy$;
    private resize$;
    constructor(nzConfigService: NzConfigService, cdr: ChangeDetectorRef, mediaMatcher: MediaMatcher, platform: Platform, nzDomEventService: NzDomEventService);
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterContentInit(): void;
    ngOnDestroy(): void;
    /**
     * Prepare the render matrix according to description items' spans.
     */
    private prepareMatrix;
    private matchMedia;
    private getColumn;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzDescriptionsComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzDescriptionsComponent, "nz-descriptions", ["nzDescriptions"], {
    "nzLayout": "nzLayout";
    "nzTitle": "nzTitle";
    "nzBordered": "nzBordered";
    "nzColumn": "nzColumn";
    "nzSize": "nzSize";
    "nzColon": "nzColon";
}, {}, ["items"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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