/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class NzEmptyComponent implements OnChanges, OnInit, OnDestroy {
    private sanitizer;
    private i18n;
    private cdr;
    nzNotFoundImage: string | TemplateRef<void>;
    nzNotFoundContent: string | TemplateRef<void>;
    nzNotFoundFooter: string | TemplateRef<void>;
    defaultSvg: import("@angular/platform-browser").SafeResourceUrl;
    isContentString: boolean;
    locale: {
        [key: string]: string;
    };
    readonly shouldRenderContent: boolean;
    private destroy$;
    constructor(sanitizer: DomSanitizer, i18n: NzI18nService, cdr: ChangeDetectorRef);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzEmptyComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzEmptyComponent, "nz-empty", ["nzEmpty"], {
    "nzNotFoundImage": "nzNotFoundImage";
    "nzNotFoundContent": "nzNotFoundContent";
    "nzNotFoundFooter": "nzNotFoundFooter";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnotZW1wdHkuY29tcG9uZW50LmQudHMiLCJzb3VyY2VzIjpbIm56LWVtcHR5LmNvbXBvbmVudC5kLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7OztBQUNBIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEFsaWJhYmEuY29tIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9naXRodWIuY29tL05HLVpPUlJPL25nLXpvcnJvLWFudGQvYmxvYi9tYXN0ZXIvTElDRU5TRVxuICovXG5pbXBvcnQgeyBDaGFuZ2VEZXRlY3RvclJlZiwgT25DaGFuZ2VzLCBPbkRlc3Ryb3ksIE9uSW5pdCwgU2ltcGxlQ2hhbmdlcywgVGVtcGxhdGVSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IERvbVNhbml0aXplciB9IGZyb20gJ0Bhbmd1bGFyL3BsYXRmb3JtLWJyb3dzZXInO1xuaW1wb3J0IHsgTnpJMThuU2VydmljZSB9IGZyb20gJ25nLXpvcnJvLWFudGQvaTE4bic7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBOekVtcHR5Q29tcG9uZW50IGltcGxlbWVudHMgT25DaGFuZ2VzLCBPbkluaXQsIE9uRGVzdHJveSB7XG4gICAgcHJpdmF0ZSBzYW5pdGl6ZXI7XG4gICAgcHJpdmF0ZSBpMThuO1xuICAgIHByaXZhdGUgY2RyO1xuICAgIG56Tm90Rm91bmRJbWFnZTogc3RyaW5nIHwgVGVtcGxhdGVSZWY8dm9pZD47XG4gICAgbnpOb3RGb3VuZENvbnRlbnQ6IHN0cmluZyB8IFRlbXBsYXRlUmVmPHZvaWQ+O1xuICAgIG56Tm90Rm91bmRGb290ZXI6IHN0cmluZyB8IFRlbXBsYXRlUmVmPHZvaWQ+O1xuICAgIGRlZmF1bHRTdmc6IGltcG9ydChcIkBhbmd1bGFyL3BsYXRmb3JtLWJyb3dzZXJcIikuU2FmZVJlc291cmNlVXJsO1xuICAgIGlzQ29udGVudFN0cmluZzogYm9vbGVhbjtcbiAgICBsb2NhbGU6IHtcbiAgICAgICAgW2tleTogc3RyaW5nXTogc3RyaW5nO1xuICAgIH07XG4gICAgcmVhZG9ubHkgc2hvdWxkUmVuZGVyQ29udGVudDogYm9vbGVhbjtcbiAgICBwcml2YXRlIGRlc3Ryb3kkO1xuICAgIGNvbnN0cnVjdG9yKHNhbml0aXplcjogRG9tU2FuaXRpemVyLCBpMThuOiBOekkxOG5TZXJ2aWNlLCBjZHI6IENoYW5nZURldGVjdG9yUmVmKTtcbiAgICBuZ09uQ2hhbmdlcyhjaGFuZ2VzOiBTaW1wbGVDaGFuZ2VzKTogdm9pZDtcbiAgICBuZ09uSW5pdCgpOiB2b2lkO1xuICAgIG5nT25EZXN0cm95KCk6IHZvaWQ7XG59XG4iXX0=