/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ElementRef, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { NzDirectionVHType, NzSizeLDSType, NzUpdateHostClassService } from 'ng-zorro-antd/core';
import { Observable } from 'rxjs';
import { NzListGrid } from './interface';
import * as ɵngcc0 from '@angular/core';
export declare class NzListComponent implements OnInit, OnChanges, OnDestroy {
    private el;
    private updateHostClassService;
    nzDataSource: any[];
    nzBordered: boolean;
    nzGrid: NzListGrid;
    nzHeader: string | TemplateRef<void>;
    nzFooter: string | TemplateRef<void>;
    nzItemLayout: NzDirectionVHType;
    nzRenderItem: TemplateRef<void>;
    nzLoading: boolean;
    nzLoadMore: TemplateRef<void>;
    nzPagination: TemplateRef<void>;
    nzSize: NzSizeLDSType;
    nzSplit: boolean;
    nzNoResult: string | TemplateRef<void>;
    private prefixCls;
    private _setClassMap;
    private itemLayoutNotifySource;
    readonly itemLayoutNotify$: Observable<NzDirectionVHType>;
    constructor(el: ElementRef, updateHostClassService: NzUpdateHostClassService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzListComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzListComponent, "nz-list, [nz-list]", ["nzList"], {
    "nzBordered": "nzBordered";
    "nzItemLayout": "nzItemLayout";
    "nzLoading": "nzLoading";
    "nzSize": "nzSize";
    "nzSplit": "nzSplit";
    "nzDataSource": "nzDataSource";
    "nzGrid": "nzGrid";
    "nzHeader": "nzHeader";
    "nzFooter": "nzFooter";
    "nzRenderItem": "nzRenderItem";
    "nzLoadMore": "nzLoadMore";
    "nzPagination": "nzPagination";
    "nzNoResult": "nzNoResult";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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