/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ReplaySubject, Subject } from 'rxjs';
import { NzOptionGroupComponent } from './nz-option-group.component';
import { NzOptionComponent } from './nz-option.component';
import { TFilterOption } from './nz-option.pipe';
import * as ɵngcc0 from '@angular/core';
export declare class NzSelectService {
    /** Input params **/
    autoClearSearchValue: boolean;
    serverSearch: boolean;
    filterOption: TFilterOption;
    mode: 'default' | 'multiple' | 'tags';
    maxMultipleCount: number;
    disabled: boolean;
    compareWith: (o1: any, o2: any) => boolean;
    /** selectedValueChanged should emit ngModelChange or not **/
    private listOfSelectedValueWithEmit$;
    /** ContentChildren Change **/
    private mapOfTemplateOption$;
    /** searchValue Change **/
    private searchValueRaw$;
    private listOfFilteredOption;
    private openRaw$;
    private checkRaw$;
    private open;
    clearInput$: Subject<boolean>;
    searchValue: string;
    isShowNotFound: boolean;
    /** animation event **/
    animationEvent$: Subject<unknown>;
    /** open event **/
    open$: import("rxjs").Observable<boolean>;
    activatedOption: NzOptionComponent | null;
    activatedOption$: ReplaySubject<NzOptionComponent | null>;
    listOfSelectedValue$: import("rxjs").Observable<any[]>;
    modelChange$: import("rxjs").Observable<any[] | null>;
    searchValue$: import("rxjs").Observable<string>;
    listOfSelectedValue: any[];
    /** flat ViewChildren **/
    listOfTemplateOption: NzOptionComponent[];
    /** tag option **/
    listOfTagOption: NzOptionComponent[];
    /** tag option concat template option **/
    listOfTagAndTemplateOption: NzOptionComponent[];
    /** ViewChildren **/
    listOfNzOptionComponent: NzOptionComponent[];
    listOfNzOptionGroupComponent: NzOptionGroupComponent[];
    /** click or enter add tag option **/
    addedTagOption: NzOptionComponent | null;
    /** display in top control **/
    listOfCachedSelectedOption: NzOptionComponent[];
    /** selected value or ViewChildren change **/
    valueOrOption$: import("rxjs").Observable<[any[], {
        listOfNzOptionComponent: NzOptionComponent[];
        listOfNzOptionGroupComponent: NzOptionGroupComponent[];
    }]>;
    check$: import("rxjs").Observable<unknown>;
    clickOption(option: NzOptionComponent): void;
    updateListOfCachedOption(): void;
    updateListOfTagOption(): void;
    updateAddTagOption(): void;
    updateListOfFilteredOption(): void;
    clearInput(): void;
    updateListOfSelectedValue(value: any[], emit: boolean): void;
    updateActivatedOption(option: NzOptionComponent | null): void;
    tokenSeparate(inputValue: string, tokenSeparators: string[]): void;
    includesSeparators(str: string | string[], separators: string[]): boolean;
    splitBySeparators(str: string | string[], separators: string[]): string[];
    resetActivatedOptionIfNeeded(): void;
    updateTemplateOption(listOfNzOptionComponent: NzOptionComponent[], listOfNzOptionGroupComponent: NzOptionGroupComponent[]): void;
    updateSearchValue(value: string): void;
    updateSelectedValueByLabelList(listOfLabel: string[]): void;
    onKeyDown(e: KeyboardEvent): void;
    removeValueFormSelected(option: NzOptionComponent): void;
    setOpenState(value: boolean): void;
    check(): void;
    readonly isSingleMode: boolean;
    readonly isTagsMode: boolean;
    readonly isMultipleMode: boolean;
    readonly isMultipleOrTags: boolean;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSelectService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzSelectService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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