/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Portal } from '@angular/cdk/portal';
import { ChangeDetectorRef, Injector, OnChanges, OnDestroy, OnInit, SimpleChanges, ViewContainerRef } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import { Subscription } from 'rxjs';
import { NzEmptyCustomContent, NzEmptySize } from './nz-empty-config';
import { NzEmptyService } from './nz-empty.service';
import * as ɵngcc0 from '@angular/core';
export declare class NzEmbedEmptyComponent implements OnChanges, OnInit, OnDestroy {
    emptyService: NzEmptyService;
    private sanitizer;
    private viewContainerRef;
    private cdr;
    private injector;
    nzComponentName: string;
    specificContent: NzEmptyCustomContent;
    content?: NzEmptyCustomContent;
    contentType: 'component' | 'template' | 'string';
    contentPortal?: Portal<any>;
    defaultSvg: import("@angular/platform-browser").SafeResourceUrl;
    size: NzEmptySize;
    subs_: Subscription;
    constructor(emptyService: NzEmptyService, sanitizer: DomSanitizer, viewContainerRef: ViewContainerRef, cdr: ChangeDetectorRef, injector: Injector);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    private getEmptySize;
    private renderEmpty;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzEmbedEmptyComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzEmbedEmptyComponent, "nz-embed-empty", ["nzEmbedEmpty"], {
    "nzComponentName": "nzComponentName";
    "specificContent": "specificContent";
}, {}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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