/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ElementRef, EventEmitter, OnChanges, OnDestroy, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { Subject } from 'rxjs';
import { NzTabLinkDirective } from './nz-tab-link.directive';
import * as ɵngcc0 from '@angular/core';
export declare class NzTabComponent implements OnChanges, OnDestroy {
    elementRef: ElementRef;
    private renderer;
    position: number | null;
    origin: number | null;
    isActive: boolean;
    readonly stateChanges: Subject<void>;
    content: TemplateRef<void>;
    title: TemplateRef<void>;
    template: TemplateRef<void>;
    linkDirective: NzTabLinkDirective;
    nzTitle: string | TemplateRef<void>;
    nzRouterIdentifier: string;
    nzForceRender: boolean;
    nzDisabled: boolean;
    readonly nzClick: EventEmitter<void>;
    readonly nzSelect: EventEmitter<void>;
    readonly nzDeselect: EventEmitter<void>;
    constructor(elementRef: ElementRef, renderer: Renderer2);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTabComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTabComponent, "nz-tab", ["nzTab"], {
    "nzForceRender": "nzForceRender";
    "nzDisabled": "nzDisabled";
    "nzTitle": "nzTitle";
    "nzRouterIdentifier": "nzRouterIdentifier";
}, {
    "nzClick": "nzClick";
    "nzSelect": "nzSelect";
    "nzDeselect": "nzDeselect";
}, ["template", "linkDirective"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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