// pg.event.emit('img_voice_play_voice_start')
// pg.event.emit('img_voice_play_voice_end')

import pg from "../../scene/tool/pg_hy02_paopao";



const { ccclass, property } = cc._decorator;

@ccclass
export default class ImgVoice extends cc.Component {
    private img_npc_voice: cc.Node;
    onLoad() {
        this.initView();
        this.initEvent();
    }
    initView() {
        this.img_npc_voice = this.node;
    }
    initEvent() {
        pg.event.on('img_voice_play_voice_start', () => {
            this.playVoiceStart();
        })
        pg.event.on('img_voice_play_voice_end', () => {
            this.playVoiceEnd();
        })
    }
    private playVoiceCount: number;
    playVoiceStart() {
        if (this.playVoiceCount > 0) return;
        this.playVoiceCount = 0;
        this.schedule(this.playVoiceRunning, 0.3)
    }
    playVoiceRunning() {
        this.playVoiceCount++;
        let p1 = this.img_npc_voice.getChildByName('p1')
        let p2 = this.img_npc_voice.getChildByName('p2')
        let p3 = this.img_npc_voice.getChildByName('p3')
        p1.active = this.playVoiceCount % 3 == 0;
        p2.active = this.playVoiceCount % 3 == 1;
        p3.active = this.playVoiceCount % 3 == 2;
    }
    playVoiceEnd() {
        this.unschedule(this.playVoiceRunning)
        this.playVoiceCount = 0;
        let p1 = this.img_npc_voice.getChildByName('p1')
        let p2 = this.img_npc_voice.getChildByName('p2')
        let p3 = this.img_npc_voice.getChildByName('p3')
        p1.active = true;
        p2.active = false;
        p3.active = false;
    }
}


