
export enum FISH_OUT {
    RUNNING,
    TOUCH,
    CATCH,
    ESCAP,
    OUT
}
export class Fish {
    public isOut: number;
    public node: cc.Node;
    public isLeft: boolean;//在左侧 向右运动
    constructor() {
        this.isOut = 0;
        this.isLeft = Math.random() < 0.5;
    }
}
export class Option {
    public type;
    public txt;
    public picUrl;
    public audioUrl;
    public right: boolean;
    public data;
    public id: number;
    public count: number;
    public time: number;
    public touchRight: boolean;
    public parent;
    public pairKey;
    public fish: any;
    constructor(data, id) {
        this.type = data.type;
        // this.count = 0;
        this.txt = data.text;
        // this.time = data.duration;
        this.picUrl = data.image;
        this.audioUrl = data.audio;
        this.right = data.right;
        // this.touchRight = false;
    }
}
export class Item {
    public page;
    public audio;
    public text;
    public image;
    public optionList;
    public checkMore: boolean;
    public type: string;
    public rNum: number;
    constructor(data, page) {
        this.audio = data.audioUrl;
        this.text = data.text;
        this.image = data.questImg;
        this.type = data.type;
        this.optionList = [];
        this.optionList = data.options.map((o, idx) => {
            return new Option(o, idx);
        });

        this.optionList.sort(function () {
            return (0.5 - Math.random());
        });
        // this.rNum = 0;
        // for (let i = 0; i < this.optionList.length; i++) {
        //     if (this.optionList[i].right) this.rNum++;
        // }
        // // this.checkMore = this.rNum > 1;
        this.page = page;
    }
}
class Role {
    public score: number;
    public right: number;
    public error: number;
    public voices: Array<any>;
    constructor() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
    addScore(score: number = 1) {
        this.score += score;
    }
    addError(score: number = 1) {
        this.error += score;
    }
    addRight() {
        this.right += 1;
    }
    addVoice(obj: any) {
        this.voices.push(obj);
    }
}
export class Player extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
}
export class Robot extends Role {
    constructor() {
        super();
    }
    reset() {
        this.score = 0;
        this.error = 0;
        this.right = 0;
        this.voices = [];
    }
}
export enum GAME_STATE {
    WAIT,
    RUNNING,
    OVER
}
export default class Game {
    private static ins: Game;
    public static getIns(): Game {
        if (!Game.ins) Game.ins = new Game();
        return Game.ins;
    }
    private data: any;
    private lists: Array<Item>
    public player: Player;
    public robot: Robot;
    public state: GAME_STATE;
    public total: number;

    constructor() {
        this.start = false;
        this.lists = [];
        this.player = new Player();
        this.robot = new Robot();
        this.state = GAME_STATE.WAIT;
    }
    get len() {
        return this.lists.length;
    }
    public question: { text, audio };
    public title: string;
    public isCanClick: boolean;
    public failCount;
    public dispelCount;
    public aniEnter;
    public startAudio: string;
    // public questionText: string;
    public init(data) {
        // this.question = { text: data.questionText, audio: data.questionTextAudio };
        this.title = data.title;
        this.startAudio = data.startAudio || "";
        // this.questionText = data.questionText;
        this.start = false;
        this.lists = [];
        this.data = data.questions;
        this.aniEnter = data.imgAni;
    }
    public start: boolean;
    public page: number;
    reset() {
        this.isCanClick = false;
        this.failCount = 0;
        this.dispelCount = 0;
        this.player.reset();
        this.robot.reset();
        this.page = 1;
        this.start = true;
        this.lists = [];
        for (let i = 0; i < this.data.length; i++) {
            let data = this.data[i];
            this.lists.push(new Item(data, i + 1));
        }
        this.state = GAME_STATE.WAIT;
        this.total = this.lists.length;
    }
    public getCardInfo() {
        let option: Item = this.lists.splice(0, 1)[0];
        // if (this.lists.length > 0) {
        //     let random = Math.floor(Math.random() * this.lists.length);
        //     option = this.lists.splice(random, 1)[0];
        // } else {
        //     option = null;
        // }
        console.log(" this.cardInfo=======", option)
        return option;
    }
    // checkSuccess(arr: Option[]) {
    //     let data = this.getCurrentPage();
    //     let options = data.optionList.concat();
    //     options.sort((A, B) => A.id - B.id)
    //     for (let i = 0; i < options.length; i++) {
    //         if (arr[i] && arr[i].id != options[i].id) {
    //             return false;
    //         }
    //     }
    //     return true;
    // }


    // getDataByPage(page): Item {
    //     return this.lists.filter(li => li.page == page)[0]
    // }
    public getRightNum() {
        let count = 0;
        this.lists.forEach((item) => {
            count += item.rNum;
        })
        return count;
    }
    getCurrentPage(): Item {
        let page = this.page;
        return this.lists.filter(li => li.page == page)[0]
    }
    getTotalPageNum() {
        return this.lists.length;
    }
    getCurrentPageNum() {
        return this.page;
    }
    addPage() {
        this.page += 1;
    }
    get getTotla() {
        return this.lists.length;
        // this.total = 0;
        // this.lists.forEach((item) => {
        //     this.total += item.rNum;
        // })
        // return this.total;
    }
    get isOver() {
        return this.page > this.lists.length;
    }
}

