/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, EventEmitter, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { CandyDate } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare type ModeType = 'month' | 'year';
export declare type DateTemplate = TemplateRef<{
    $implicit: Date;
}>;
export declare class NzCalendarComponent implements ControlValueAccessor {
    private cdr;
    activeDate: CandyDate;
    prefixCls: string;
    private onChangeFn;
    private onTouchFn;
    nzMode: ModeType;
    readonly nzModeChange: EventEmitter<ModeType>;
    readonly nzPanelChange: EventEmitter<{
        date: Date;
        mode: ModeType;
    }>;
    readonly nzSelectChange: EventEmitter<Date>;
    nzValue: Date;
    readonly nzValueChange: EventEmitter<Date>;
    /**
     * Cannot use @Input and @ContentChild on one variable
     * because { static: false } will make @Input property get delayed
     **/
    nzDateCell: DateTemplate;
    nzDateCellChild: DateTemplate;
    readonly dateCell: DateTemplate;
    nzDateFullCell: DateTemplate;
    nzDateFullCellChild: DateTemplate;
    readonly dateFullCell: DateTemplate;
    nzMonthCell: DateTemplate;
    nzMonthCellChild: DateTemplate;
    readonly monthCell: DateTemplate;
    nzMonthFullCell: DateTemplate;
    nzMonthFullCellChild: DateTemplate;
    readonly monthFullCell: DateTemplate;
    nzFullscreen: boolean;
    /**
     * @deprecated use `[nzFullscreen]` instead.
     */
    nzCard: boolean;
    constructor(cdr: ChangeDetectorRef);
    onModeChange(mode: ModeType): void;
    onYearSelect(year: number): void;
    onMonthSelect(month: number): void;
    onDateSelect(date: CandyDate): void;
    writeValue(value: Date | null): void;
    registerOnChange(fn: (date: Date) => void): void;
    registerOnTouched(fn: () => void): void;
    private updateDate;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzCalendarComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzCalendarComponent, "nz-calendar", ["nzCalendar"], {
    "nzMode": "nzMode";
    "nzFullscreen": "nzFullscreen";
    "nzValue": "nzValue";
    "nzCard": "nzCard";
    "nzDateCell": "nzDateCell";
    "nzDateFullCell": "nzDateFullCell";
    "nzMonthCell": "nzMonthCell";
    "nzMonthFullCell": "nzMonthFullCell";
}, {
    "nzModeChange": "nzModeChange";
    "nzPanelChange": "nzPanelChange";
    "nzSelectChange": "nzSelectChange";
    "nzValueChange": "nzValueChange";
}, ["nzDateCellChild", "nzDateFullCellChild", "nzMonthCellChild", "nzMonthFullCellChild"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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