/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { AfterContentInit, AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnDestroy, QueryList, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { NzConfigService, NzDomEventService, NzDragService } from 'ng-zorro-antd/core';
import { NzCarouselContentDirective } from './nz-carousel-content.directive';
import { FromToInterface, NzCarouselDotPosition, NzCarouselEffects, NzCarouselStrategyRegistryItem } from './nz-carousel-definitions';
import { NzCarouselBaseStrategy } from './strategies/base-strategy';
import * as ɵngcc0 from '@angular/core';
export declare class NzCarouselComponent implements AfterContentInit, AfterViewInit, OnDestroy, OnChanges {
    readonly nzConfigService: NzConfigService;
    private readonly renderer;
    private readonly cdr;
    private readonly platform;
    private readonly nzDomEventService;
    private readonly nzDragService;
    private customStrategies;
    carouselContents: QueryList<NzCarouselContentDirective>;
    slickList: ElementRef;
    slickTrack: ElementRef;
    nzDotRender: TemplateRef<{
        $implicit: number;
    }>;
    nzEffect: NzCarouselEffects;
    nzEnableSwipe: boolean;
    nzDots: boolean;
    nzAutoPlay: boolean;
    nzAutoPlaySpeed: number;
    nzTransitionSpeed: number;
    nzVertical: boolean;
    nzDotPosition: NzCarouselDotPosition;
    private _dotPosition;
    readonly nzBeforeChange: EventEmitter<FromToInterface>;
    readonly nzAfterChange: EventEmitter<number>;
    activeIndex: number;
    el: HTMLElement;
    slickListEl: HTMLElement;
    slickTrackEl: HTMLElement;
    strategy: NzCarouselBaseStrategy;
    vertical: boolean;
    transitionInProgress: number | null;
    private destroy$;
    private gestureRect;
    private pointerDelta;
    private isTransiting;
    private isDragging;
    constructor(elementRef: ElementRef, nzConfigService: NzConfigService, renderer: Renderer2, cdr: ChangeDetectorRef, platform: Platform, nzDomEventService: NzDomEventService, nzDragService: NzDragService, customStrategies: NzCarouselStrategyRegistryItem[]);
    ngAfterContentInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    onKeyDown(e: KeyboardEvent): void;
    next(): void;
    pre(): void;
    goTo(index: number): void;
    private switchStrategy;
    private scheduleNextTransition;
    private clearScheduledTransition;
    private markContentActive;
    /**
     * Drag carousel.
     * @param event
     */
    pointerDown: (event: TouchEvent | MouseEvent) => void;
    private syncStrategy;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzCarouselComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzCarouselComponent, "nz-carousel", ["nzCarousel"], {
    "nzTransitionSpeed": "nzTransitionSpeed";
    "nzVertical": "nzVertical";
    "nzDotPosition": "nzDotPosition";
    "nzDotRender": "nzDotRender";
    "nzEffect": "nzEffect";
    "nzEnableSwipe": "nzEnableSwipe";
    "nzDots": "nzDots";
    "nzAutoPlay": "nzAutoPlay";
    "nzAutoPlaySpeed": "nzAutoPlaySpeed";
}, {
    "nzBeforeChange": "nzBeforeChange";
    "nzAfterChange": "nzAfterChange";
}, ["carouselContents"]>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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