/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnChanges, SimpleChanges, TemplateRef } from '@angular/core';
import { NgClassType, NzConfigService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzAlertComponent implements OnChanges {
    nzConfigService: NzConfigService;
    nzCloseText: string | TemplateRef<void>;
    nzIconType: NgClassType;
    nzMessage: string | TemplateRef<void>;
    nzDescription: string | TemplateRef<void>;
    nzType: 'success' | 'info' | 'warning' | 'error';
    nzCloseable: boolean;
    nzShowIcon: boolean;
    nzBanner: boolean;
    readonly nzOnClose: EventEmitter<boolean>;
    readonly iconType: NgClassType;
    destroy: boolean;
    iconTheme: string;
    isIconTypeObject: boolean;
    private isTypeSet;
    private isShowIconSet;
    private inferredIconType;
    constructor(nzConfigService: NzConfigService);
    closeAlert(): void;
    onFadeAnimationDone(): void;
    updateIconClassMap(): void;
    ngOnChanges(changes: SimpleChanges): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzAlertComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzAlertComponent, "nz-alert", ["nzAlert"], {
    "nzType": "nzType";
    "nzBanner": "nzBanner";
    "nzShowIcon": "nzShowIcon";
    "nzCloseText": "nzCloseText";
    "nzIconType": "nzIconType";
    "nzMessage": "nzMessage";
    "nzDescription": "nzDescription";
    "nzCloseable": "nzCloseable";
}, {
    "nzOnClose": "nzOnClose";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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