/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, OnInit } from '@angular/core';
import { CandyDate } from 'ng-zorro-antd/core';
import { DateHelperService, NzI18nService as I18n } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class NzCalendarHeaderComponent implements OnInit {
    private i18n;
    private dateHelper;
    mode: 'month' | 'year';
    fullscreen: boolean;
    readonly modeChange: EventEmitter<'month' | 'year'>;
    activeDate: CandyDate;
    readonly yearChange: EventEmitter<number>;
    readonly monthChange: EventEmitter<number>;
    yearOffset: number;
    yearTotal: number;
    years: Array<{
        label: string;
        value: number;
    }>;
    months: Array<{
        label: string;
        value: number;
    }>;
    readonly activeYear: number;
    readonly activeMonth: number;
    readonly size: string;
    readonly yearTypeText: string;
    readonly monthTypeText: string;
    constructor(i18n: I18n, dateHelper: DateHelperService);
    ngOnInit(): void;
    updateYear(year: number): void;
    private setUpYears;
    private setUpMonths;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzCalendarHeaderComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzCalendarHeaderComponent, "nz-calendar-header", ["nzCalendarHeader"], {
    "mode": "mode";
    "fullscreen": "fullscreen";
    "activeDate": "activeDate";
}, {
    "modeChange": "modeChange";
    "yearChange": "yearChange";
    "monthChange": "monthChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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