/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { error, ANT_ICON_ANGULAR_CONSOLE_PREFIX } from '../utils';
/**
 * @return {?}
 */
export function NameSpaceIsNotSpecifyError() {
    return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "Type should have a namespace. Try \"namespace:" + name + "\".");
}
/**
 * @param {?} icon
 * @return {?}
 */
export function IconNotFoundError(icon) {
    return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "the icon " + icon + " does not exist or is not registered.");
}
/**
 * @return {?}
 */
export function HttpModuleNotImport() {
    error("you need to import \"HttpClientModule\" to use dynamic importing.");
    return null;
}
/**
 * @param {?} url
 * @return {?}
 */
export function UrlNotSafeError(url) {
    return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "The url \"" + url + "\" is unsafe.");
}
/**
 * @return {?}
 */
export function SVGTagNotFoundError() {
    return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "<svg> tag not found.");
}
/**
 * @return {?}
 */
export function DynamicLoadingTimeoutError() {
    return new Error(ANT_ICON_ANGULAR_CONSOLE_PREFIX + "Importing timeout error.");
}
//# sourceMappingURL=data:application/json;base64,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