/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { Platform } from '@angular/cdk/platform';
import { ChangeDetectorRef, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { ExtendedMark, NzMarks, SliderHandler, SliderShowTooltip, SliderValue } from './nz-slider-definitions';
import * as ɵngcc0 from '@angular/core';
export declare class NzSliderComponent implements ControlValueAccessor, OnInit, OnChanges, OnDestroy {
    private cdr;
    private platform;
    slider: ElementRef<HTMLDivElement>;
    nzDisabled: boolean;
    nzDots: boolean;
    nzIncluded: boolean;
    nzRange: boolean;
    nzVertical: boolean;
    nzDefaultValue: SliderValue | null;
    nzMarks: NzMarks | null;
    nzMax: number;
    nzMin: number;
    nzStep: number;
    nzTooltipVisible: SliderShowTooltip;
    nzTooltipPlacement: string;
    nzTipFormatter: (value: number) => string;
    readonly nzOnAfterChange: EventEmitter<SliderValue>;
    value: SliderValue | null;
    sliderDOM: HTMLDivElement;
    cacheSliderStart: number | null;
    cacheSliderLength: number | null;
    activeValueIndex: number | undefined;
    track: {
        offset: null | number;
        length: null | number;
    };
    handles: SliderHandler[];
    marksArray: ExtendedMark[] | null;
    bounds: {
        lower: SliderValue | null;
        upper: SliderValue | null;
    };
    isDragging: boolean;
    private dragStart$;
    private dragMove$;
    private dragEnd$;
    private dragStart_;
    private dragMove_;
    private dragEnd_;
    constructor(cdr: ChangeDetectorRef, platform: Platform);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    writeValue(val: SliderValue | null): void;
    onValueChange(_value: SliderValue): void;
    onTouched(): void;
    registerOnChange(fn: (value: SliderValue) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
    private setValue;
    private getValue;
    /**
     * Clone & sort current value and convert them to offsets, then return the new one.
     */
    private getValueToOffset;
    /**
     * Find the closest value to be activated (only for range = true).
     */
    private setActiveValueIndex;
    private setActiveValue;
    /**
     * Update track and handles' position and length.
     */
    private updateTrackAndHandles;
    private onDragStart;
    private onDragMove;
    private onDragEnd;
    /**
     * Create user interactions handles.
     */
    private createDraggingObservables;
    private subscribeDrag;
    private unsubscribeDrag;
    private toggleDragMoving;
    private toggleDragDisabled;
    private findClosestValue;
    private valueToOffset;
    private getSliderStartPosition;
    private getSliderLength;
    /**
     * Cache DOM layout/reflow operations for performance (may not necessary?)
     */
    private cacheSliderProperty;
    private formatValue;
    /**
     * Check if value is valid and throw error if value-type/range not match.
     */
    private assertValueValid;
    /**
     * Assert that if `this.nzRange` is `true`, value is also a range, vice versa.
     */
    private assertValueTypeMatch;
    private valuesEqual;
    /**
     * Show one handle's tooltip and hide others'.
     */
    private showHandleTooltip;
    private hideAllHandleTooltip;
    private generateHandles;
    private generateMarkItems;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzSliderComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzSliderComponent, "nz-slider", ["nzSlider"], {
    "nzDisabled": "nzDisabled";
    "nzDots": "nzDots";
    "nzIncluded": "nzIncluded";
    "nzRange": "nzRange";
    "nzVertical": "nzVertical";
    "nzDefaultValue": "nzDefaultValue";
    "nzMarks": "nzMarks";
    "nzMax": "nzMax";
    "nzMin": "nzMin";
    "nzStep": "nzStep";
    "nzTooltipVisible": "nzTooltipVisible";
    "nzTooltipPlacement": "nzTooltipPlacement";
    "nzTipFormatter": "nzTipFormatter";
}, {
    "nzOnAfterChange": "nzOnAfterChange";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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