/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { OnDestroy } from '@angular/core';
import { BehaviorSubject, Subject } from 'rxjs';
import { NzCascaderComponentAsSource, NzCascaderOption, NzCascaderSearchOption } from './nz-cascader-definitions';
/**
 * All data is stored and parsed in NzCascaderService.
 */
import * as ɵngcc0 from '@angular/core';
export declare class NzCascaderService implements OnDestroy {
    /** Activated options in each column. */
    activatedOptions: NzCascaderOption[];
    /** An array to store cascader items arranged in different layers. */
    columns: NzCascaderOption[][];
    /** If user has entered searching mode. */
    inSearchingMode: boolean;
    /** Selected options would be output to user. */
    selectedOptions: NzCascaderOption[];
    values: any[];
    readonly $loading: BehaviorSubject<boolean>;
    /**
     * Emit an event to notify cascader it needs to redraw because activated or
     * selected options are changed.
     */
    readonly $redraw: Subject<void>;
    /**
     * Emit an event when an option gets selected.
     * Emit true if a leaf options is selected.
     */
    readonly $optionSelected: Subject<{
        option: import("./nz-cascader-definitions").CascaderOption;
        index: number;
    } | null>;
    /**
     * Emit an event to notify cascader it needs to quit searching mode.
     * Only emit when user do select a searching option.
     */
    readonly $quitSearching: Subject<void>;
    /** To hold columns before entering searching mode. */
    private columnsSnapshot;
    /** To hold activated options before entering searching mode. */
    private activatedOptionsSnapshot;
    private cascaderComponent;
    /** Return cascader options in the first layer. */
    readonly nzOptions: NzCascaderOption[];
    ngOnDestroy(): void;
    /**
     * Make sure that value matches what is displayed in the dropdown.
     */
    syncOptions(first?: boolean): void;
    /**
     * Bind cascader component so this service could use inputs.
     */
    withComponent(cascaderComponent: NzCascaderComponentAsSource): void;
    /**
     * Reset all options. Rebuild searching options if in searching mode.
     */
    withOptions(options: NzCascaderOption[] | null): void;
    /**
     * Try to set a option as activated.
     * @param option Cascader option
     * @param columnIndex Of which column this option is in
     * @param performSelect Select
     * @param loadingChildren Try to load children asynchronously.
     */
    setOptionActivated(option: NzCascaderOption, columnIndex: number, performSelect?: boolean, loadingChildren?: boolean): void;
    setOptionSelected(option: NzCascaderOption, index: number): void;
    setOptionDeactivatedSinceColumn(column: number): void;
    /**
     * Set a searching option as selected, finishing up things.
     * @param option
     */
    setSearchOptionSelected(option: NzCascaderSearchOption): void;
    /**
     * Filter cascader options to reset `columns`.
     * @param searchValue The string user wants to search.
     */
    prepareSearchOptions(searchValue: string): void;
    /**
     * Toggle searching mode by UI. It deals with things not directly related to UI.
     * @param toSearching If this cascader is entering searching mode
     */
    toggleSearchingMode(toSearching: boolean): void;
    /**
     * Clear selected options.
     */
    clear(): void;
    getOptionLabel(o: NzCascaderOption): string;
    getOptionValue(o: NzCascaderOption): any;
    /**
     * Try to insert options into a column.
     * @param options Options to insert
     * @param columnIndex Position
     */
    private setColumnData;
    /**
     * Set all ancestor options as activated.
     */
    private trackAncestorActivatedOptions;
    private dropBehindActivatedOptions;
    private dropBehindColumns;
    /**
     * Load children of an option asynchronously.
     */
    loadChildren(option: NzCascaderOption | any, // tslint:disable-line:no-any
    columnIndex: number, success?: VoidFunction, failure?: VoidFunction): void;
    private isLoaded;
    /**
     * Find a option that has a given value in a given column.
     */
    private findOptionWithValue;
    private prepareEmitValue;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzCascaderService>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<NzCascaderService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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