/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { EventEmitter, TemplateRef } from '@angular/core';
import { isNonEmptyString, isTemplateRef, CandyDate } from 'ng-zorro-antd/core';
import { NzCalendarI18nInterface } from 'ng-zorro-antd/i18n';
import * as ɵngcc0 from '@angular/core';
export declare class CalendarFooterComponent {
    locale: NzCalendarI18nInterface;
    showToday: boolean;
    hasTimePicker: boolean;
    isRange: boolean;
    showTimePicker: boolean;
    readonly showTimePickerChange: EventEmitter<boolean>;
    timePickerDisabled: boolean;
    okDisabled: boolean;
    disabledDate: (d: Date) => boolean;
    extraFooter: TemplateRef<void> | string;
    rangeQuickSelector: TemplateRef<void>;
    readonly clickOk: EventEmitter<void>;
    readonly clickToday: EventEmitter<CandyDate>;
    prefixCls: string;
    isTemplateRef: typeof isTemplateRef;
    isNonEmptyString: typeof isNonEmptyString;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<CalendarFooterComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<CalendarFooterComponent, "calendar-footer", ["calendarFooter"], {
    "showToday": "showToday";
    "hasTimePicker": "hasTimePicker";
    "isRange": "isRange";
    "showTimePicker": "showTimePicker";
    "timePickerDisabled": "timePickerDisabled";
    "okDisabled": "okDisabled";
    "locale": "locale";
    "disabledDate": "disabledDate";
    "extraFooter": "extraFooter";
    "rangeQuickSelector": "rangeQuickSelector";
}, {
    "showTimePickerChange": "showTimePickerChange";
    "clickOk": "clickOk";
    "clickToday": "clickToday";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FsZW5kYXItZm9vdGVyLmNvbXBvbmVudC5kLnRzIiwic291cmNlcyI6WyJjYWxlbmRhci1mb290ZXIuY29tcG9uZW50LmQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQ0EiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgQWxpYmFiYS5jb20gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2dpdGh1Yi5jb20vTkctWk9SUk8vbmctem9ycm8tYW50ZC9ibG9iL21hc3Rlci9MSUNFTlNFXG4gKi9cbmltcG9ydCB7IEV2ZW50RW1pdHRlciwgVGVtcGxhdGVSZWYgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IGlzTm9uRW1wdHlTdHJpbmcsIGlzVGVtcGxhdGVSZWYsIENhbmR5RGF0ZSB9IGZyb20gJ25nLXpvcnJvLWFudGQvY29yZSc7XG5pbXBvcnQgeyBOekNhbGVuZGFySTE4bkludGVyZmFjZSB9IGZyb20gJ25nLXpvcnJvLWFudGQvaTE4bic7XG5leHBvcnQgZGVjbGFyZSBjbGFzcyBDYWxlbmRhckZvb3RlckNvbXBvbmVudCB7XG4gICAgbG9jYWxlOiBOekNhbGVuZGFySTE4bkludGVyZmFjZTtcbiAgICBzaG93VG9kYXk6IGJvb2xlYW47XG4gICAgaGFzVGltZVBpY2tlcjogYm9vbGVhbjtcbiAgICBpc1JhbmdlOiBib29sZWFuO1xuICAgIHNob3dUaW1lUGlja2VyOiBib29sZWFuO1xuICAgIHJlYWRvbmx5IHNob3dUaW1lUGlja2VyQ2hhbmdlOiBFdmVudEVtaXR0ZXI8Ym9vbGVhbj47XG4gICAgdGltZVBpY2tlckRpc2FibGVkOiBib29sZWFuO1xuICAgIG9rRGlzYWJsZWQ6IGJvb2xlYW47XG4gICAgZGlzYWJsZWREYXRlOiAoZDogRGF0ZSkgPT4gYm9vbGVhbjtcbiAgICBleHRyYUZvb3RlcjogVGVtcGxhdGVSZWY8dm9pZD4gfCBzdHJpbmc7XG4gICAgcmFuZ2VRdWlja1NlbGVjdG9yOiBUZW1wbGF0ZVJlZjx2b2lkPjtcbiAgICByZWFkb25seSBjbGlja09rOiBFdmVudEVtaXR0ZXI8dm9pZD47XG4gICAgcmVhZG9ubHkgY2xpY2tUb2RheTogRXZlbnRFbWl0dGVyPENhbmR5RGF0ZT47XG4gICAgcHJlZml4Q2xzOiBzdHJpbmc7XG4gICAgaXNUZW1wbGF0ZVJlZjogdHlwZW9mIGlzVGVtcGxhdGVSZWY7XG4gICAgaXNOb25FbXB0eVN0cmluZzogdHlwZW9mIGlzTm9uRW1wdHlTdHJpbmc7XG59XG4iXX0=