/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { AfterViewInit, ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NgClassType, NzConfigService } from 'ng-zorro-antd/core';
import * as ɵngcc0 from '@angular/core';
export declare class NzRateComponent implements OnInit, OnDestroy, ControlValueAccessor, AfterViewInit, OnChanges {
    nzConfigService: NzConfigService;
    private renderer;
    private cdr;
    private ulElement;
    nzAllowClear: boolean;
    nzAllowHalf: boolean;
    nzDisabled: boolean;
    nzAutoFocus: boolean;
    nzCharacter: TemplateRef<void>;
    nzTooltips: string[];
    readonly nzOnBlur: EventEmitter<FocusEvent>;
    readonly nzOnFocus: EventEmitter<FocusEvent>;
    readonly nzOnHoverChange: EventEmitter<number>;
    readonly nzOnKeyDown: EventEmitter<KeyboardEvent>;
    classMap: NgClassType;
    hasHalf: boolean;
    hoverValue: number;
    prefixCls: string;
    innerPrefixCls: string;
    isFocused: boolean;
    isInit: boolean;
    starArray: number[];
    private destroy$;
    private _count;
    private _value;
    nzCount: number;
    nzValue: number;
    constructor(nzConfigService: NzConfigService, renderer: Renderer2, cdr: ChangeDetectorRef);
    ngOnChanges(changes: SimpleChanges): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngAfterViewInit(): void;
    onItemClick(index: number, isHalf: boolean): void;
    onItemHover(index: number, isHalf: boolean): void;
    onRateLeave(): void;
    onFocus(e: FocusEvent): void;
    onBlur(e: FocusEvent): void;
    focus(): void;
    blur(): void;
    onKeyDown(e: KeyboardEvent): void;
    setClasses(i: number): object;
    private updateStarArray;
    writeValue(value: number | null): void;
    setDisabledState(isDisabled: boolean): void;
    registerOnChange(fn: (_: number) => void): void;
    registerOnTouched(fn: () => void): void;
    onChange: (value: number) => void;
    onTouched: () => void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzRateComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzRateComponent, "nz-rate", ["nzRate"], {
    "nzDisabled": "nzDisabled";
    "nzAutoFocus": "nzAutoFocus";
    "nzTooltips": "nzTooltips";
    "nzCount": "nzCount";
    "nzAllowClear": "nzAllowClear";
    "nzAllowHalf": "nzAllowHalf";
    "nzCharacter": "nzCharacter";
}, {
    "nzOnBlur": "nzOnBlur";
    "nzOnFocus": "nzOnFocus";
    "nzOnHoverChange": "nzOnHoverChange";
    "nzOnKeyDown": "nzOnKeyDown";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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