# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v1.1.10](https://github.com/inspect-js/is-typed-array/compare/v1.1.9...v1.1.10) - 2022-11-02

### Commits

- [meta] add `auto-changelog` [`cf6d86b`](https://github.com/inspect-js/is-typed-array/commit/cf6d86bf2f693eca357439d4d12e76d641f91f92)
- [actions] update rebase action to use reusable workflow [`8da51a5`](https://github.com/inspect-js/is-typed-array/commit/8da51a5dce6d2442ae31ccbc2be136f2e04d6bef)
- [Dev Deps] update `aud`, `is-callable`, `object-inspect`, `tape` [`554e3de`](https://github.com/inspect-js/is-typed-array/commit/554e3deec59dec926d0badc628e589ab363e465b)
- [Refactor] use `gopd` instead of an `es-abstract` helper` [`cdaa465`](https://github.com/inspect-js/is-typed-array/commit/cdaa465d5f94bfc9e32475e31209e1c2458a9603)
- [Deps] update `es-abstract` [`677ae4b`](https://github.com/inspect-js/is-typed-array/commit/677ae4b3c8323b59d6650a9254ab945045c33f79)

<!-- auto-changelog-above -->

1.1.9 / 2022-05-13
=================
  * [Refactor] use `foreach` instead of `for-each`
  * [readme] markdown URL cleanup
  * [Deps] update `es-abstract`
  * [meta] use `npmignore` to autogenerate an npmignore file
  * [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `object-inspect`, `safe-publish-latest`, `tape`
  * [actions] reuse common workflows
  * [actions] update codecov uploader

1.1.8 / 2021-08-30
=================
  * [Refactor] use `globalThis` if available (#53)
  * [Deps] update `available-typed-arrays`
  * [Dev Deps] update `@ljharb/eslint-config`

1.1.7 / 2021-08-07
=================
  * [Fix] if Symbol.toStringTag exists but is not present, use Object.prototype.toString
  * [Dev Deps] update `is-callable`, `tape`

1.1.6 / 2021-08-05
=================
  * [Fix] use `has-tostringtag` to behave correctly in the presence of symbol shams
  * [readme] add actions and codecov badges
  * [meta] use `prepublishOnly` script for npm 7+
  * [Deps] update `available-typed-arrays`, `es-abstract`
  * [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `object-inspect`, `tape`
  * [actions] use `node/install` instead of `node/run`; use `codecov` action

1.1.5 / 2021-02-14
=================
  * [meta] do not publish github action workflow files or nyc output
  * [Deps] update `call-bind`, `es-abstract`
  * [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `aud`, `is-callable`, `tape`

1.1.4 / 2020-12-05
=================
  * [readme] fix repo URLs, remove defunct badges
  * [Deps] update `available-typed-arrays`, `es-abstract`; use `call-bind` where applicable
  * [meta] gitignore nyc output
  * [meta] only audit prod deps
  * [actions] add "Allow Edits" workflow
  * [actions] switch Automatic Rebase workflow to `pull_request_target` event
  * [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `is-callable`, `make-arrow-function`, `make-generator-function`, `object-inspect`, `tape`; add `aud`
  * [Tests] migrate tests to Github Actions
  * [Tests] run `nyc` on all tests

1.1.3 / 2020-01-24
=================
  * [Refactor] use `es-abstract`’s `callBound`, `available-typed-arrays`, `has-symbols`

1.1.2 / 2020-01-20
=================
  * [Fix] in envs without Symbol.toStringTag, dc8a8cc made arrays return `true`
  * [Tests] add `evalmd` to `prelint`

1.1.1 / 2020-01-18
=================
  * [Robustness] don’t rely on Array.prototype.indexOf existing
  * [meta] remove unused Makefile and associated utilities
  * [meta] add `funding` field; create FUNDING.yml
  * [actions] add automatic rebasing / merge commit blocking
  * [Dev Deps] update `eslint`, `@ljharb/eslint-config`, `is-callable`, `replace`, `semver`, `tape`; add `safe-publish-latest`
  * [Tests] use shared travis-ci configs
  * [Tests] use `npx aud` instead of `nsp` or `npm audit` with hoops

1.1.0 / 2019-02-16
=================
  * [New] add `BigInt64Array` and `BigUint64Array`
  * [Refactor] use an array instead of an object for storing Typed Array names
  * [meta] ignore `test.html`
  * [Tests] up to `node` `v11.10`, `v10.15`, `v8.15`, `v7.10`, `v6.16`, `v5.10`, `v4.9`
  * [Tests] remove `jscs`
  * [Tests] use `npm audit` instead of `nsp`
  * [Dev Deps] update `eslint`,` @ljharb/eslint-config`, `is-callable`, `tape`, `replace`, `semver`
  * [Dev Deps] remove unused eccheck script + dep

1.0.4 / 2016-03-19
=================
  * [Fix] `Symbol.toStringTag` is on the super-`[[Prototype]]` of Float32Array, not the `[[Prototype]]` (#3)
  * [Tests] up to `node` `v5.9`, `v4.4`
  * [Tests] use pretest/posttest for linting/security
  * [Dev Deps] update `tape`, `jscs`, `nsp`, `eslint`, `@ljharb/eslint-config`, `semver`, `is-callable`

1.0.3 / 2015-10-13
=================
  * [Deps] Add missing `foreach` dependency (#1)

1.0.2 / 2015-10-05
=================
  * [Deps] Remove unneeded "isarray" dependency
  * [Dev Deps] update `eslint`, `@ljharb/eslint-config`

1.0.1 / 2015-10-02
=================
  * Rerelease: avoid instanceof and the constructor property; work cross-realm; work with Symbol.toStringTag.

1.0.0 / 2015-05-06
=================
  * Initial release.
