/**
 * @license
 * Copyright Alibaba.com All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://github.com/NG-ZORRO/ng-zorro-antd/blob/master/LICENSE
 */
import { ChangeDetectorRef, ElementRef, EventEmitter, OnDestroy, OnInit } from '@angular/core';
import { NzI18nService } from 'ng-zorro-antd/i18n';
import { NzAutosizeDirective } from 'ng-zorro-antd/input';
import * as ɵngcc0 from '@angular/core';
export declare class NzTextEditComponent implements OnInit, OnDestroy {
    private host;
    private cdr;
    private i18n;
    editing: boolean;
    locale: any;
    private destroy$;
    text: string;
    readonly startEditing: EventEmitter<void>;
    readonly endEditing: EventEmitter<string>;
    textarea: ElementRef<HTMLTextAreaElement>;
    autosizeDirective: NzAutosizeDirective;
    beforeText: string;
    currentText: string;
    nativeElement: any;
    constructor(host: ElementRef, cdr: ChangeDetectorRef, i18n: NzI18nService);
    ngOnInit(): void;
    ngOnDestroy(): void;
    onClick(): void;
    confirm(): void;
    onInput(event: Event): void;
    onEnter(event: KeyboardEvent): void;
    onCancel(): void;
    focusAndSetValue(): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<NzTextEditComponent>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<NzTextEditComponent, "nz-text-edit", ["nzTextEdit"], {
    "text": "text";
}, {
    "startEditing": "startEditing";
    "endEditing": "endEditing";
}, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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