import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { ComponentBase } from './ComponentBase';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "hy07_tiankong";
  // 储存对象
  item: any = {
    npcTitle: "",
    npcAudio: "",
    npcAudioName: '',
    // score: 0,
    title: '07填空',
    // questionText: "彩蛋里藏了哪些魔法卡牌呢？亲爱的小玩家，快用锤子砸开彩蛋，魔法卡牌就会露出来，只要正确地说出魔法咒语，你就能获得这张魔法卡牌。 游戏结束后，根据获得的魔法卡牌数量，你将获得相应的能量石奖励！开始挑战吧！",
    // questionTextAudio: "http://staging-teach.cdn.ireadabc.com/61b41f87fffc8390a519668fece764d3_l.mp3",
    questions: [],
  };

  init(): void {
    if (!this.item.npcTitle) this.item.npcTitle = '';
    if (!this.item.npcAudio) this.item.npcAudio = '';
    if (!this.item.npcAudioName) this.item.npcAudioName = '';
  }
  isVisible = false;
  deleteTitle = "是否删除题目";
  deleteCallback = function () { };
  openDelete(title, callback) {
    this.deleteCallback = callback;
    this.deleteTitle = title;
    this.isVisible = true;
  }
  handleCancel() {
    this.isVisible = false;
  }
  handleOk() {
    this.deleteCallback && this.deleteCallback();
    this.handleCancel();
  }

  addQuestion() {
    this.item.questions.push({
      // options: [],
      contentArr: [],
      audio: '',
      contentMain: "",
      text: '',
      audioName: "",
    });
    this.save();
  }

  removeQuestion(idx) {
    this.openDelete("确定删除题目？", () => {
      this.item.questions.splice(idx, 1);
      this.save();
    })
  }
  copyQuestion(idx) {
    let data = this.item.questions[idx]
    this.item.questions.push(JSON.parse(JSON.stringify(data)));
    this.save();
  }
  deleteBgAudio() {
    this.item.bgAudio = "";
    this.item.audioBgName = "";
    this.save();
  }
  addOption(idx) {
    if (this.item.questions[idx].options.length == 4) return;
    this.item.questions[idx].options.push({
      type: 'txt',
      pic_url: '',
      text: '',
      audio_url: '',
      audioName: "",
    });
    this.save();
  }

  removeOption(idx, n) {
    this.openDelete("确定删除选项？", () => {
      this.item.questions[idx].options.splice(n, 1);
      this.save();
    })
  }
  ngChange() {
    this.save();
  }

  changeMain(question) {
    //输出的数据可以识别到\n的换行符
    let arr = question.contentMain.split(" ");
    let oldArr = question.contentArr.concat();
    let contetArr = arr.map(ar => {
      let obj = {
        text: ar.replaceAll("\n", "") + " ",//`${ar} `,
        block: false,
        check: 1,
      }
      for (let i = 0; i < oldArr.length; i++) {
        if (obj.text == oldArr[i].text) {
          obj.block = oldArr[i].block;
          obj.check = oldArr[i].check;
          oldArr.splice(i, 1);
          break;
        }
      }
      return obj;
    })
    question.contentArr = contetArr;
    console.log(contetArr)
    this.save();
  }
  onBlock(item, vis) {
    item.block = vis;
    this.save();
  }
}